/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.ofbiz.DatabaseIterator;
import com.atlassian.jira.ofbiz.EmptyIterator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.CloseableIterator;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.ListOrderComparator;
import com.atlassian.jira.util.collect.ResolvingComparator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.ofbiz.core.entity.GenericValue;

public abstract class PagedDatabaseIterable<E, K>
implements EnclosedIterable<E> {
    private static final int DEFAULT_PAGE_SIZE = 100;
    private final List<K> ids;
    private final Function<E, K> keyResolver;
    private final int pageSize;

    public PagedDatabaseIterable(List<K> ids) {
        this(ids, null);
    }

    public PagedDatabaseIterable(List<K> ids, Resolver<E, K> keyResolver) {
        this(ids, keyResolver, 100);
    }

    public PagedDatabaseIterable(List<K> ids, Resolver<E, K> keyResolver, int pageSize) {
        this.ids = Collections.unmodifiableList((List)Assertions.notNull((String)"ids", ids));
        this.keyResolver = keyResolver != null ? arg_0 -> keyResolver.apply(arg_0) : null;
        this.pageSize = pageSize;
    }

    CloseableIterator<E> iterator() {
        if (this.isEmpty()) {
            return new EmptyIterator();
        }
        if (this.keyResolver != null) {
            return new SortedIterator<E, K>(this.keyResolver, this.ids, new PagingIterator(this.ids, this.pageSize, this::getResolver, this::createListIterator));
        }
        return new PagingIterator(this.ids, this.pageSize, this::getResolver, this::createListIterator);
    }

    public final void foreach(Consumer<E> consumer) {
        CloseableIterator.Functions.foreach(this.iterator(), consumer);
    }

    protected abstract OfBizListIterator createListIterator(List<K> var1);

    protected abstract Resolver<GenericValue, E> getResolver();

    public final int size() {
        return this.ids.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static final class PagingIterator<E, K>
    implements CloseableIterator<E> {
        private CloseableIterator<E> delegate = new EmptyIterator();
        private int end = 0;
        private final List<K> ids;
        private final int pageSize;
        private final Supplier<Resolver<GenericValue, E>> resolverFactory;
        private final Function<List<K>, OfBizListIterator> iteratorFactory;

        public PagingIterator(List<K> ids, int pageSize, Supplier<Resolver<GenericValue, E>> resolverFactory, Function<List<K>, OfBizListIterator> iteratorFactory) {
            this.ids = ids;
            this.pageSize = pageSize;
            this.resolverFactory = resolverFactory;
            this.iteratorFactory = iteratorFactory;
            this.createDelegate();
        }

        @Override
        public E next() {
            if (!this.delegate.hasNext() && this.hasMorePages()) {
                this.createDelegate();
            }
            return this.delegate.next();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext() || this.hasMorePages();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        private boolean hasMorePages() {
            return this.end < this.ids.size();
        }

        private void createDelegate() {
            int start = this.end;
            this.end = Math.min(start + this.pageSize, this.ids.size());
            this.delegate.close();
            this.delegate = new DatabaseIterator((Resolver)this.resolverFactory.get(), this.iteratorFactory.apply(this.ids.subList(start, this.end)));
        }
    }

    private static final class SortedIterator<E, K>
    implements CloseableIterator<E> {
        private final Iterator<E> it;

        SortedIterator(Function<E, K> keyResolver, List<K> ids, PagingIterator<E, K> delegate) {
            ArrayList list = new ArrayList(new CloseableIterator.ListResolver().get(delegate));
            Collections.sort(list, new ResolvingComparator<E, K>(keyResolver, new ListOrderComparator<K>(ids)));
            this.it = list.iterator();
        }

        @Override
        public E next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public void close() {
        }
    }
}

