/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding;

import com.atlassian.jira.onboarding.FirstUseFlow;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.descriptors.ConditionDescriptorFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.descriptors.ConditionalDescriptor;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.dom4j.Element;

public class FirstUseFlowModuleDescriptor
extends AbstractJiraModuleDescriptor<FirstUseFlow>
implements Comparable<FirstUseFlowModuleDescriptor>,
ConditionalDescriptor {
    @VisibleForTesting
    static final int UNWEIGHTED = -1;
    private int weight;
    private Condition condition;
    private Element element;
    private Plugin plugin;
    private final ConditionDescriptorFactory conditionDescriptorFactory;

    public FirstUseFlowModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory, ConditionDescriptorFactory conditionDescriptorFactory) {
        super(authenticationContext, moduleFactory);
        this.conditionDescriptorFactory = conditionDescriptorFactory;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        String weightValue = element.attributeValue("weight");
        try {
            this.weight = Integer.parseInt(weightValue);
        }
        catch (NumberFormatException e) {
            this.weight = -1;
        }
        this.plugin = plugin;
        this.element = element;
    }

    @Override
    public void enabled() {
        super.enabled();
        this.condition = this.conditionDescriptorFactory.retrieveCondition(this.plugin, this.element);
    }

    @Override
    public void disabled() {
        super.disabled();
        this.condition = null;
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(@Nullable FirstUseFlowModuleDescriptor o) {
        if (o == null) {
            return -1;
        }
        return Integer.valueOf(o.getWeight()).compareTo(this.getWeight());
    }

    public Condition getCondition() {
        return this.condition;
    }
}

