/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionGrantInput;
import com.atlassian.jira.permission.PermissionHolder;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionTypesManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.lang.JiraStringUtils;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public class PermissionGrantValidator {
    private final PermissionTypeManager permissionTypeManager;
    private final ProjectPermissionTypesManager projectPermissionsManager;
    private final I18nHelper i18n;
    private final GroupManager groupManager;
    private final CustomFieldManager customFieldManager;
    private final ProjectRoleManager projectRoleManager;
    private final UserManager userManager;

    public PermissionGrantValidator(PermissionTypeManager permissionTypeManager, ProjectPermissionTypesManager projectPermissionsManager, I18nHelper i18nHelper, GroupManager groupManager, CustomFieldManager customFieldManager, ProjectRoleManager projectRoleManager, UserManager userManager) {
        this.permissionTypeManager = permissionTypeManager;
        this.projectPermissionsManager = projectPermissionsManager;
        this.i18n = i18nHelper;
        this.groupManager = groupManager;
        this.customFieldManager = customFieldManager;
        this.projectRoleManager = projectRoleManager;
        this.userManager = userManager;
    }

    public ErrorCollection validateGrants(ApplicationUser user, Iterable<PermissionGrantInput> grants) {
        ErrorCollection result = ErrorCollections.empty();
        for (PermissionGrantInput grant : grants) {
            result.addErrorCollection(this.validateGrant(user, grant));
        }
        return result;
    }

    public ErrorCollection validateGrant(ApplicationUser user, PermissionGrantInput grants) {
        ErrorCollection errorCollection = this.initialValidation(grants);
        return errorCollection.hasAnyErrors() ? errorCollection : this.validationImplementedByTypes(user, grants);
    }

    private ErrorCollection initialValidation(PermissionGrantInput grant) {
        ErrorCollection result = ErrorCollections.empty();
        result.addErrorCollection(this.validatePermission(grant.getPermission()));
        result.addErrorCollection(this.validateHolder(grant.getHolder()));
        return result;
    }

    private ErrorCollection validatePermission(ProjectPermissionKey permission) {
        if (!this.projectPermissionsManager.exists(permission)) {
            return ErrorCollections.validationError((String)"permission", (String)this.i18n.getText("admin.schemes.permissions.validation.permission.unrecognized", (Object)permission));
        }
        return ErrorCollections.empty();
    }

    private ErrorCollection validateHolder(PermissionHolder holder) {
        Option holderType = JiraPermissionHolderType.fromKey((String)holder.getType().getKey(), (String)((String)holder.getParameter().getOrNull()));
        if (holderType.isDefined()) {
            switch ((JiraPermissionHolderType)holderType.get()) {
                case GROUP: {
                    if (this.groupManager.groupExists((String)holder.getParameter().get())) break;
                    return ErrorCollections.validationError((String)"holder.parameter", (String)this.i18n.getText("admin.schemes.permissions.validation.group.does.not.exist", (String)holder.getParameter().get()));
                }
                case USER_CUSTOM_FIELD: 
                case GROUP_CUSTOM_FIELD: {
                    return this.validateCustomField((String)holder.getParameter().get());
                }
                case PROJECT_ROLE: {
                    Option roleId = JiraStringUtils.toLong((String)((String)holder.getParameter().get()));
                    if (roleId.isEmpty()) {
                        return ErrorCollections.validationError((String)"holder.parameter", (String)this.i18n.getText("admin.schemes.permissions.validation.project.role.id.must.be.number"));
                    }
                    if (this.projectRoleManager.getProjectRole((Long)roleId.get()) != null) break;
                    return ErrorCollections.validationError((String)"holder.parameter", (String)this.i18n.getText("admin.schemes.permissions.validation.project.role.does.not.exist", (String)holder.getParameter().get()));
                }
                case USER: {
                    if (this.userManager.getUserByName((String)holder.getParameter().get()) != null) break;
                    return ErrorCollections.validationError((String)"holder.parameter", (String)this.i18n.getText("admin.schemes.permissions.validation.user.does.not.exist", (String)holder.getParameter().get()));
                }
                default: {
                    return ErrorCollections.empty();
                }
            }
        }
        return ErrorCollections.empty();
    }

    private ErrorCollection validateCustomField(String customField) {
        if (!this.customFieldManager.exists(customField)) {
            return ErrorCollections.validationError((String)"holder.parameter", (String)this.i18n.getText("admin.schemes.permissions.validation.cf.does.not.exist", customField));
        }
        return ErrorCollections.empty();
    }

    private Map<String, String> getParameters(final PermissionHolder holder) {
        return (Map)holder.getParameter().map((Function)new Function<String, Map<String, String>>(){

            @Override
            public Map<String, String> apply(String parameter) {
                return ImmutableMap.of((Object)holder.getType().getKey(), (Object)parameter);
            }
        }).getOrElse(Collections.emptyMap());
    }

    private ErrorCollection validationImplementedByTypes(ApplicationUser user, PermissionGrantInput entity) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(user, ErrorCollections.empty(), this.i18n);
        String key = entity.getHolder().getType().getKey();
        SchemeType type = (SchemeType)this.permissionTypeManager.getSchemeType(key);
        if (type == null) {
            return ErrorCollections.validationError((String)"holder.type", (String)this.i18n.getText("admin.schemes.permissions.validation.holder.type.unrecognized", key));
        }
        if (!type.isValidForPermission(entity.getPermission())) {
            return ErrorCollections.create((String)this.i18n.getText("admin.permissions.errors.invalid.combination", entity.getPermission().permissionKey(), key), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
        }
        type.doValidation(key, this.getParameters(entity.getHolder()), (JiraServiceContext)context);
        return context.getErrorCollection();
    }
}

