/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.event.listeners.reindex.ReindexMessageListener;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.ClusterAwareJiraPluginController;
import com.atlassian.jira.plugin.JiraFailedPluginTracker;
import com.atlassian.jira.plugin.JiraPluginSystemListener;
import com.atlassian.jira.plugin.PluginLoaderFactory;
import com.atlassian.jira.plugin.PluginPath;
import com.atlassian.jira.plugin.PluginVersion;
import com.atlassian.jira.plugin.PluginVersionImpl;
import com.atlassian.jira.plugin.PluginVersionStore;
import com.atlassian.jira.plugin.component.ComponentModuleDescriptor;
import com.atlassian.jira.plugin.ha.PluginMessageSender;
import com.atlassian.jira.plugin.startup.PluginVersionsChangeAnalyser;
import com.atlassian.jira.plugin.startup.PluginVersionsChangeReport;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.startup.JiraStartupPluginSystemListener;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginRegistry;
import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.atlassian.plugin.exception.PluginExceptionInterception;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.manager.SafeModeManager;
import com.atlassian.plugin.repositories.FilePluginInstaller;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.LazyReference;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraPluginManager
extends DefaultPluginManager
implements Startable,
ClusterAwareJiraPluginController {
    private static final Logger log = LoggerFactory.getLogger(JiraPluginManager.class);
    private final PluginVersionStore pluginVersionStore;
    @ClusterSafe(value="This reference has no node-specific state")
    private final LazyReference<PluginMessageSender> pluginMessageSenderRef = new LazyReference<PluginMessageSender>(){

        protected PluginMessageSender create() {
            return (PluginMessageSender)ComponentAccessor.getComponent(PluginMessageSender.class);
        }
    };
    private final JiraPluginSystemListener jiraPluginSystemListener;
    private final PluginPath pluginPath;
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;
    private final PluginVersionsChangeAnalyser pluginVersionsChangeAnalyser;
    private volatile boolean inStartup = false;
    private final ReindexMessageListener reindexMessageListener;

    public JiraPluginManager(PluginAccessor pluginAccessor, PluginRegistry.ReadWrite pluginRegistry, PluginPersistentStateStore store, PluginLoaderFactory pluginLoaderFactory, ModuleDescriptorFactory moduleDescriptorFactory, PluginVersionStore pluginVersionStore, PluginEventManager pluginEventManager, PluginPath pluginPath, JiraPluginSystemListener jiraPluginSystemListener, JiraFailedPluginTracker failedPluginTracker, EventPublisher eventPublisher, SafeModeManager safeModeManager, ReindexMessageListener reindexMessageListener, PluginVersionsChangeAnalyser pluginVersionsChangeAnalyser) {
        super(JiraPluginManager.newBuilder().withPluginAccessor(pluginAccessor).withPluginRegistry(pluginRegistry).withStore(store).withPluginLoaders(pluginLoaderFactory.getPluginLoaders()).withSafeModeManager(safeModeManager).withModuleDescriptorFactory(moduleDescriptorFactory).withPluginEventManager(pluginEventManager).withPluginExceptionInterception((PluginExceptionInterception)failedPluginTracker));
        this.pluginAccessor = pluginAccessor;
        this.pluginVersionStore = pluginVersionStore;
        this.jiraPluginSystemListener = jiraPluginSystemListener;
        this.pluginPath = pluginPath;
        this.eventPublisher = eventPublisher;
        this.reindexMessageListener = reindexMessageListener;
        this.pluginVersionsChangeAnalyser = pluginVersionsChangeAnalyser;
        this.setPluginInstaller((PluginInstaller)new JiraPluginInstaller(eventPublisher, pluginPath.getInstalledPluginsDirectory()));
    }

    public void start() throws PluginException {
        this.earlyStartup();
        this.lateStartup();
    }

    public void earlyStartup() throws PluginParseException, NotificationException {
        JiraStartupLogger.log().info((Object)"\n\n___ Starting the JIRA Plugin System _________________\n");
        this.inStartup = true;
        super.earlyStartup();
    }

    public void lateStartup() {
        super.lateStartup();
        this.processPluginSystemChanges();
        this.inStartup = false;
        JiraStartupLogger.log().info((Object)"\n\n___ Plugin System Started _________________\n");
    }

    public void enablePlugins(String ... keys) {
        super.enablePlugins(keys);
        for (String key : keys) {
            this.processEnabledPlugin(key);
            this.trySend(sender -> sender.sendPluginEnabledMessage(key));
        }
    }

    private void trySend(Consumer<PluginMessageSender> callback) {
        Optional.ofNullable(this.pluginMessageSenderRef.get()).ifPresent(callback);
    }

    @Override
    public void enablePluginsLocalOnly(String ... keys) {
        super.enablePlugins(keys);
        for (String key : keys) {
            this.processEnabledPlugin(key);
        }
    }

    protected void addPlugins(PluginLoader loader, Collection<Plugin> pluginsToInstall) throws PluginParseException {
        JiraStartupPluginSystemListener.addPlugins(pluginsToInstall.size());
        super.addPlugins(loader, pluginsToInstall);
    }

    @Override
    public String installPluginLocalOnly(PluginArtifact pluginArtifact) throws PluginParseException {
        return (String)Iterables.getOnlyElement((Iterable)super.installPlugins(new PluginArtifact[]{pluginArtifact}));
    }

    public Set<String> installPlugins(PluginArtifact ... pluginArtifacts) throws PluginParseException {
        Set keys = super.installPlugins(pluginArtifacts);
        for (String key : keys) {
            this.trySend(sender -> sender.sendPluginInstalledMessage(key));
        }
        return keys;
    }

    @Override
    public Set<String> installPluginsLocalOnly(PluginArtifact ... pluginArtifacts) throws PluginParseException {
        return super.installPlugins(pluginArtifacts);
    }

    @PluginEventListener
    public void onPluginEnabledEvent(PluginEnabledEvent enabledEvent) {
        Plugin plugin = enabledEvent.getPlugin();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Plugin with key '%s' has been enabled.", plugin.getKey()));
        }
        if (!this.inStartup) {
            this.pluginVersionStore.save(new PluginVersionImpl(plugin.getKey(), plugin.getName(), plugin.getPluginInformation().getVersion(), new Date()));
        }
    }

    @PluginEventListener
    public void onPluginUninstalledEvent(PluginUninstalledEvent uninstalledEvent) {
        Plugin plugin = uninstalledEvent.getPlugin();
        String pluginKey = plugin.getKey();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Plugin with key '%s' has been uninstalled.", pluginKey));
        }
        this.pluginVersionStore.deleteByKey(pluginKey);
        PluginArtifact pluginArtifact = plugin.getPluginArtifact();
        if (pluginArtifact != null) {
            this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_DELETED, JiraHomeChangeEvent.FileType.PLUGIN, new File(this.pluginPath.getInstalledPluginsDirectory(), pluginArtifact.getName())));
        }
    }

    @PluginEventListener
    public void onPluginDisabledEvent(PluginDisabledEvent disabledEvent) {
        Plugin plugin = disabledEvent.getPlugin();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Plugin with key '%s' has been disabled.", plugin.getKey()));
        }
    }

    @PluginEventListener
    public void onPluginUpgradedEvent(PluginUpgradedEvent upgradedEvent) {
        this.trySend(sender -> sender.sendPluginUpgradedMessage(upgradedEvent.getPlugin().getKey()));
    }

    private void processEnabledPlugin(String key) {
        Plugin plugin = this.pluginAccessor.getPlugin(key);
        if (plugin != null) {
            Collection funNewComponents = this.pluginAccessor.getPlugin(key).getModuleDescriptors();
            for (ModuleDescriptor moduleDescriptor : funNewComponents) {
                if (!(moduleDescriptor instanceof ComponentModuleDescriptor) || !this.isPluginModuleEnabled(moduleDescriptor.getCompleteKey())) continue;
                ComponentModuleDescriptor componentModuleDescriptor = (ComponentModuleDescriptor)moduleDescriptor;
                componentModuleDescriptor.registerComponent(ComponentManager.getInstance());
            }
        } else {
            log.error("Could not enable plugin with key '" + key + "'");
        }
    }

    public void uninstall(Plugin plugin) throws PluginException {
        super.uninstall(plugin);
        this.trySend(sender -> sender.sendPluginUninstalledMessage(plugin.getKey()));
    }

    @Override
    public void uninstallLocalOnly(Plugin plugin) throws PluginException {
        super.uninstall(plugin);
    }

    public void disablePlugin(String key) {
        this.disablePluginLocalOnly(key);
        this.trySend(sender -> sender.sendPluginDisabledMessage(key));
    }

    @Override
    public void disablePluginLocalOnly(String key) {
        this.unregisterComponents(key);
        super.disablePlugin(key);
        if (!ComponentManager.getInstance().getState().isPluginSystemStarted()) {
            log.warn("Disable Plugin with key '" + key + "' called before Plugin System Started.", (Throwable)new RuntimeException());
        }
    }

    public void disablePluginWithoutPersisting(String key) {
        this.unregisterComponents(key);
        super.disablePluginWithoutPersisting(key);
        if (ComponentManager.getInstance().getState().isPluginSystemStarted() && log.isDebugEnabled()) {
            log.debug("Disabling plugin with key  '" + key + "' without persisting. This should occur if this plugin depends on a plugin that is currently being upgraded");
        }
    }

    private void unregisterComponents(String key) {
        Plugin plugin = this.pluginAccessor.getPlugin(key);
        if (plugin == null) {
            log.warn(String.format("Attempted to unregister components for non existing plugin '%s'", key));
        } else {
            for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
                if (!(moduleDescriptor instanceof ComponentModuleDescriptor) || !this.isPluginModuleEnabled(moduleDescriptor.getCompleteKey())) continue;
                ComponentModuleDescriptor componentModuleDescriptor = (ComponentModuleDescriptor)moduleDescriptor;
                componentModuleDescriptor.unregisterComponent(ComponentManager.getInstance());
            }
        }
    }

    public void disablePluginModule(String completeKey) {
        this.disablePluginModuleLocalOnly(completeKey);
        this.trySend(sender -> sender.sendPluginModuleDisabledMessage(completeKey));
    }

    @Override
    public void disablePluginModuleLocalOnly(String completeKey) {
        ModuleDescriptor moduleDescriptor = this.getEnabledPluginModule(completeKey);
        if (moduleDescriptor instanceof ComponentModuleDescriptor) {
            ((ComponentModuleDescriptor)moduleDescriptor).unregisterComponent(ComponentManager.getInstance());
        }
        super.disablePluginModule(completeKey);
    }

    public void enablePluginModule(String completeKey) {
        this.enablePluginModuleLocalOnly(completeKey);
        this.trySend(sender -> sender.sendPluginModuleEnabledMessage(completeKey));
    }

    @Override
    public void enablePluginModuleLocalOnly(String completeKey) {
        super.enablePluginModule(completeKey);
        ModuleDescriptor moduleDescriptor = this.getEnabledPluginModule(completeKey);
        if (moduleDescriptor instanceof ComponentModuleDescriptor) {
            ((ComponentModuleDescriptor)moduleDescriptor).registerComponent(ComponentManager.getInstance());
        }
    }

    void processPluginSystemChanges() {
        List<PluginVersion> storedPluginVersions = this.pluginVersionStore.getAll();
        Collection installedPluginVersions = this.pluginAccessor.getPlugins().stream().map(this::getPluginVersion).collect(Collectors.toList());
        PluginVersionsChangeReport report = this.pluginVersionsChangeAnalyser.buildReport(storedPluginVersions, installedPluginVersions);
        this.processAddedPlugins(report);
        this.processUpdatedPlugins(report);
        this.processRemovedPlugins(report);
    }

    @VisibleForTesting
    PluginVersion getPluginVersion(Plugin plugin) {
        String version = Optional.of(plugin.getPluginInformation()).map(PluginInformation::getVersion).orElse("unknown");
        return new PluginVersionImpl(plugin.getKey(), plugin.getName(), version, new Date());
    }

    private void processAddedPlugins(PluginVersionsChangeReport report) {
        for (PluginVersionsChangeReport.PluginVersionChangeEntry addedPluginReport : report.addedPlugins()) {
            PluginVersion pv = addedPluginReport.getInstalledPluginVersion();
            if (log.isInfoEnabled()) {
                log.info(String.format("Plugin with key '%s' and name '%s' and version '%s' is being added to the system.", pv.getKey(), pv.getName(), pv.getVersion()));
            }
            this.pluginVersionStore.create(pv);
            this.reindexMessageListener.handlePluginAddedOrUpgradedOnStartup(pv.getKey());
        }
    }

    private void processUpdatedPlugins(PluginVersionsChangeReport report) {
        for (PluginVersionsChangeReport.PluginVersionChangeEntry updatedPluginReport : report.updatedPlugins()) {
            PluginVersionImpl pv = new PluginVersionImpl(updatedPluginReport.getStoredPluginVersion().getId(), updatedPluginReport.getInstalledPluginVersion().getKey(), updatedPluginReport.getInstalledPluginVersion().getName(), updatedPluginReport.getInstalledPluginVersion().getVersion(), updatedPluginReport.getInstalledPluginVersion().getCreated());
            if (log.isInfoEnabled()) {
                log.info(String.format("Plugin with key '%s' and name '%s' and version '%s' is being updated to version %s.", pv.getKey(), pv.getName(), updatedPluginReport.getStoredPluginVersion().getVersion(), pv.getVersion()));
            }
            this.pluginVersionStore.update(pv);
            this.reindexMessageListener.handlePluginAddedOrUpgradedOnStartup(pv.getKey());
        }
    }

    private void processRemovedPlugins(PluginVersionsChangeReport report) {
        for (PluginVersionsChangeReport.PluginVersionChangeEntry removedPluginReport : report.removedPlugins()) {
            PluginVersion pv = removedPluginReport.getStoredPluginVersion();
            if (log.isInfoEnabled()) {
                log.info(String.format("Plugin with key '%s' and name '%s' and version '%s' is being removed from the system.", pv.getKey(), pv.getName(), pv.getVersion()));
            }
            this.pluginVersionStore.delete(pv.getId());
        }
    }

    private static class JiraPluginInstaller
    extends FilePluginInstaller {
        private final EventPublisher eventPublisher;
        private final File installedPluginsDirectory;

        JiraPluginInstaller(EventPublisher eventPublisher, File installedPluginsDirectory) {
            super(installedPluginsDirectory);
            this.eventPublisher = eventPublisher;
            this.installedPluginsDirectory = installedPluginsDirectory;
        }

        public void installPlugin(String key, PluginArtifact pluginArtifact) {
            super.installPlugin(key, pluginArtifact);
            this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_ADD, JiraHomeChangeEvent.FileType.PLUGIN, new File(this.installedPluginsDirectory, pluginArtifact.getName())));
        }
    }
}

