/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.attachment;

import com.atlassian.jira.config.util.AttachmentConfig;
import com.atlassian.jira.config.util.AttachmentConfigStore;
import com.atlassian.jira.config.util.ExtensionRestrictionMode;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.validation.AttachmentValidationError;
import com.atlassian.jira.issue.attachment.validation.BeforeUploadAttachmentValidator;
import com.atlassian.jira.issue.attachment.validation.PluggableAttachmentValidator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class AttachmentFileExtensionValidator
implements BeforeUploadAttachmentValidator {
    private final AttachmentConfigStore attachmentConfigStore;
    private final I18nHelper.BeanFactory i18nHelper;

    public AttachmentFileExtensionValidator(AttachmentConfigStore attachmentConfigStore, I18nHelper.BeanFactory i18nHelper) {
        this.attachmentConfigStore = attachmentConfigStore;
        this.i18nHelper = i18nHelper;
    }

    public Optional<AttachmentValidationError> validateBeforeUpload(@Nullable ApplicationUser user, Project project, @Nullable Issue issue, PluggableAttachmentValidator.FileInfo fileInfo) {
        AttachmentConfig config = this.attachmentConfigStore.getConfig();
        ExtensionRestrictionMode restrictionMode = config.getExtensionRestrictionMode();
        if (restrictionMode != ExtensionRestrictionMode.NONE) {
            String extension = StringUtils.defaultString((String)FilenameUtils.getExtension((String)fileInfo.getFileName()));
            String filteredExtensions = config.getFilteredFileExtensions();
            boolean matches = StringUtils.isEmpty((CharSequence)extension) ? config.isFilterFilesWithoutExtensions() : Arrays.stream(filteredExtensions.split(",")).filter(StringUtils::isNotBlank).map(StringUtils::trim).anyMatch(extension::equals);
            if (matches && restrictionMode == ExtensionRestrictionMode.BLOCKLIST || !matches && restrictionMode == ExtensionRestrictionMode.ALLOWLIST) {
                return Optional.of(new AttachmentValidationError("Attachment file extension is not allowed", StringUtils.isBlank((CharSequence)extension) ? this.i18nHelper.getInstance(user).getText("attachfile.error.empty.extension.not.allowed") : this.i18nHelper.getInstance(user).getText("attachfile.error.extension.not.allowed", "." + extension)));
            }
        }
        return Optional.empty();
    }
}

