/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.component;

import com.atlassian.jira.component.pico.ComponentContainer;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.descriptors.RequiresRestart;
import com.atlassian.plugin.module.ModuleFactory;
import javax.annotation.Nonnull;
import org.dom4j.Element;

@RequiresRestart
public class ComponentModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private static final String CLASSLOADING_MESSAGE = "Cannot %s component '%s' in plugin '%s' because we haven't loaded the class. This means that this plugin has not been successfully enabled.";
    private volatile Class<?> interfaceClass;
    private volatile String interfaceClassName;

    public ComponentModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        if (element.element("interface") != null) {
            this.interfaceClassName = element.element("interface").getTextTrim();
        }
    }

    public void enabled() {
        if (this.interfaceClassName != null) {
            try {
                this.interfaceClass = this.plugin.loadClass(this.interfaceClassName, ((Object)((Object)this)).getClass());
            }
            catch (Exception e) {
                throw new PluginException("Unable to load interface class: " + this.interfaceClassName, (Throwable)e);
            }
        }
        super.enabled();
    }

    public void disabled() {
        super.disabled();
        this.interfaceClass = null;
    }

    public Void getModule() {
        throw new UnsupportedOperationException("You cannot retrieve a component instance - Pico-ified");
    }

    public void registerComponent(@Nonnull ComponentContainer componentContainer) {
        this.checkInterfaceClassIsLoadedIfNecessary("register");
        componentContainer.registerComponent(this.interfaceClass, this.getModuleClass());
    }

    public void registerComponent(ComponentManager componentManager) {
        this.checkInterfaceClassIsLoadedIfNecessary("register");
        componentManager.registerComponent(this.interfaceClass, this.getModuleClass());
    }

    public void unregisterComponent(ComponentManager componentManager) {
        this.checkInterfaceClassIsLoadedIfNecessary("unregister");
        componentManager.unregisterComponent(this.interfaceClass, this.getModuleClass());
    }

    private void checkInterfaceClassIsLoadedIfNecessary(String action) {
        if (this.interfaceClassName != null && this.interfaceClass == null) {
            throw new PluginException(String.format(CLASSLOADING_MESSAGE, action, this.interfaceClassName, this.getKey()));
        }
    }
}

