/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.icon;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImageResolver;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.UrlBuilder;
import java.net.URI;

public class IconImageResolverImpl
implements AvatarImageResolver {
    public static final String AVATAR_ID_PARAM = "avatarId";
    public static final String SIZE_PARAM = "size";
    public static final String PATH_PREFIX = "/secure/viewavatar";
    public static final String AVATAR_TYPE_PARAM = "avatarType";
    private final JiraBaseUrls jiraBaseUrls;
    private final ApplicationProperties applicationProperties;

    public IconImageResolverImpl(JiraBaseUrls jiraBaseUrls, ApplicationProperties applicationProperties) {
        this.jiraBaseUrls = jiraBaseUrls;
        this.applicationProperties = applicationProperties;
    }

    public URI getAvatarAbsoluteUri(ApplicationUser avatarUser, Avatar avatar, Avatar.Size requestedSize) {
        URI relativeUri = this.getAvatarRelativeUri(avatarUser, avatar, requestedSize);
        String baseUrl = this.jiraBaseUrls.baseUrl();
        UrlBuilder absoluteUriBuilder = new UrlBuilder(baseUrl + relativeUri.toASCIIString());
        return absoluteUriBuilder.asURI();
    }

    public URI getAvatarRelativeUri(ApplicationUser remoteUser, Avatar avatar, Avatar.Size requestedSize) {
        UrlBuilder urlBuilder = new UrlBuilder(PATH_PREFIX, this.applicationProperties.getEncoding(), false);
        this.addAvatarParametersToUrlBuilder(urlBuilder, avatar, requestedSize);
        return urlBuilder.asURI();
    }

    private void addAvatarParametersToUrlBuilder(UrlBuilder urlBuilder, Avatar avatar, Avatar.Size size) {
        if (!this.isSizeDefaultOrNone(size)) {
            urlBuilder.addParameter(SIZE_PARAM, size.getParam());
        }
        Long avatarId = avatar.getId();
        urlBuilder.addParameter(AVATAR_ID_PARAM, avatarId.toString());
        urlBuilder.addParameter(AVATAR_TYPE_PARAM, avatar.getIconType().getKey());
    }

    private boolean isSizeDefaultOrNone(Avatar.Size size) {
        return size == null || size == Avatar.Size.defaultSize();
    }
}

