/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.profile;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.plugin.profile.OptionalUserProfilePanel;
import com.atlassian.jira.plugin.profile.ViewProfilePanel;
import com.atlassian.jira.plugin.profile.ViewProfilePanelModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class DarkFeaturesUserProfilePanel
implements ViewProfilePanel,
OptionalUserProfilePanel {
    private final JiraAuthenticationContext authenticationContext;
    private ViewProfilePanelModuleDescriptor moduleDescriptor;
    private PermissionManager permissionManager;
    private FeatureManager featureManager;
    private XsrfTokenGenerator xsrfTokenGenerator;

    public DarkFeaturesUserProfilePanel(JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, FeatureManager featureManager, XsrfTokenGenerator xsrfTokenGenerator) {
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.featureManager = featureManager;
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    public void init(ViewProfilePanelModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    @Override
    public boolean showPanel(ApplicationUser profileUser, ApplicationUser currentUser) {
        return this.featureManager.isEnabled("jira.user.darkfeature.admin") && profileUser.equals((Object)currentUser);
    }

    public String getHtml(ApplicationUser profileUser) {
        ApplicationUser user = this.authenticationContext.getUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        DarkFeatures darkFeatures = this.featureManager.getDarkFeatures();
        ArrayList globalEnabledFeatures = Lists.newArrayList((Iterable)darkFeatures.getGlobalEnabledFeatureKeys());
        ArrayList userEnabledFeatures = Lists.newArrayList((Iterable)darkFeatures.getUserEnabledFeatures());
        Collections.sort(globalEnabledFeatures);
        Collections.sort(userEnabledFeatures);
        params.put("textUtils", new TextUtils());
        params.put("isAdmin", this.permissionManager.hasPermission(44, user));
        params.put("globalEnabledFeatures", globalEnabledFeatures);
        params.put("userEnabledFeatures", userEnabledFeatures);
        params.put("atl_token", this.getXsrfToken());
        return this.moduleDescriptor.getHtml("view", params);
    }

    public String getXsrfToken() {
        return this.xsrfTokenGenerator.generateToken();
    }
}

