/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.searchrequestview.auth;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.plugin.searchrequestview.auth.Authorizer;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.commons.lang3.StringUtils;

class SearchResultSizeAuthorizer
implements Authorizer {
    private final SearchService searchService;
    private final long maxAllowed;
    private final Authorizer delegate;

    SearchResultSizeAuthorizer(SearchService searchService, long maxAllowed, Authorizer delegate) {
        Assertions.notNull((String)"searchProvider", (Object)searchService);
        Assertions.notNull((String)"delegate", (Object)delegate);
        if (maxAllowed < 0L) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot be configured with a negative maxAllowed: '" + maxAllowed + "'");
        }
        this.searchService = searchService;
        this.maxAllowed = maxAllowed;
        this.delegate = delegate;
    }

    public Authorizer.Result isSearchRequestAuthorized(ApplicationUser user, SearchRequest searchRequest, SearchRequestParams params) {
        if (!params.isReturnMax() && this.getSearchCount(user, searchRequest, params) > this.maxAllowed) {
            return new Authorizer.Failure("You are not allowed to get a result set of more than " + this.maxAllowed + " results. Current search returns " + this.getSearchCount(user, searchRequest, params) + " results");
        }
        return this.delegate.isSearchRequestAuthorized(user, searchRequest, params);
    }

    private long getSearchCount(ApplicationUser user, SearchRequest searchRequest, SearchRequestParams params) {
        if (params != null) {
            String searchCount = String.valueOf(params.getSession().get("searchCount"));
            long resultCount = StringUtils.isNumeric((CharSequence)searchCount) ? Long.parseLong(searchCount) : this.getSearchCountFromSearchProvider(user, searchRequest);
            if (params.getPagerFilter() != null) {
                return Math.min(resultCount, (long)params.getPagerFilter().getMax());
            }
            return resultCount;
        }
        return this.getSearchCountFromSearchProvider(user, searchRequest);
    }

    private long getSearchCountFromSearchProvider(ApplicationUser user, SearchRequest searchRequest) {
        try {
            return this.searchService.searchCount(user, searchRequest == null ? null : searchRequest.getQuery());
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
    }

    Authorizer getDelegate() {
        return this.delegate;
    }

    long getMaxAllowed() {
        return this.maxAllowed;
    }
}

