/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.startup;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.plugin.PluginVersion;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class PluginVersionsChangeReport {
    private final Collection<PluginVersionChangeEntry> entries;

    public static Builder builder() {
        return new Builder();
    }

    private PluginVersionsChangeReport(Collection<PluginVersionChangeEntry> analysedPluginSystemChanges) {
        this.entries = analysedPluginSystemChanges;
    }

    public Collection<PluginVersionChangeEntry> allPlugins() {
        return this.entries;
    }

    public Collection<PluginVersionChangeEntry> addedPlugins() {
        return (Collection)this.allPlugins().stream().filter(rec$ -> ((PluginVersionChangeEntry)rec$).isAdded()).collect(CollectorsUtil.toImmutableList());
    }

    public Collection<PluginVersionChangeEntry> removedPlugins() {
        return (Collection)this.allPlugins().stream().filter(rec$ -> ((PluginVersionChangeEntry)rec$).isRemoved()).collect(CollectorsUtil.toImmutableList());
    }

    public Collection<PluginVersionChangeEntry> updatedPlugins() {
        return (Collection)this.allPlugins().stream().filter(rec$ -> ((PluginVersionChangeEntry)rec$).isUpdated()).collect(CollectorsUtil.toImmutableList());
    }

    public static class PluginVersionChangeEntry {
        private final PluginVersion storedPluginVersion;
        private final PluginVersion installedPluginVersion;

        public PluginVersionChangeEntry(PluginVersion storedPluginVersion, PluginVersion installedPluginVersion) {
            if (storedPluginVersion == null && installedPluginVersion == null) {
                throw new IllegalArgumentException("Both plugin versions can't be null!");
            }
            this.storedPluginVersion = storedPluginVersion;
            this.installedPluginVersion = installedPluginVersion;
        }

        private boolean isAdded() {
            return this.storedPluginVersion == null;
        }

        private boolean isRemoved() {
            return this.installedPluginVersion == null;
        }

        private boolean isUpdated() {
            return !this.isAdded() && !this.isRemoved() && !this.installedPluginVersion.getVersion().equals(this.storedPluginVersion.getVersion());
        }

        public PluginVersion getStoredPluginVersion() {
            return this.storedPluginVersion;
        }

        public PluginVersion getInstalledPluginVersion() {
            return this.installedPluginVersion;
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<PluginVersionChangeEntry> entriesBuilder = ImmutableList.builder();
        private boolean builderIsOpen = true;

        private Builder() {
        }

        public void add(PluginVersionChangeEntry entry) {
            if (!this.builderIsOpen) {
                throw new IllegalStateException("Report has already been built.");
            }
            this.entriesBuilder.add((Object)entry);
        }

        public PluginVersionsChangeReport build() {
            if (this.builderIsOpen) {
                this.builderIsOpen = false;
                return new PluginVersionsChangeReport((Collection)this.entriesBuilder.build());
            }
            throw new IllegalStateException("Report has already been built.");
        }
    }
}

