/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.plugin.webfragment.DefaultSimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactoryModuleDescriptors;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ThreadLocalCachingSimpleLinkManager
extends DefaultSimpleLinkManager {
    private static final String LAZY_LOCATION_KEY = ThreadLocalCachingSimpleLinkManager.class.getName() + ".shouldLocationBeLazy";
    private static final String LAZY_SECTION_KEY = ThreadLocalCachingSimpleLinkManager.class.getName() + ".shouldSectionBeLazy";
    private static final String LINKS_FOR_SECTION_KEY = ThreadLocalCachingSimpleLinkManager.class.getName() + ".getLinksForSection";
    private static final String LINKS_FOR_SECTION_IC_KEY = ThreadLocalCachingSimpleLinkManager.class.getName() + ".getLinksForSectionIgnoreConditions";
    private static final String SECTIONS_FOR_LOCATION_KEY = ThreadLocalCachingSimpleLinkManager.class.getName() + ".getSectionsForLocation";
    private static final String NE_SECTIONS_FOR_LOCATION_KEY = ThreadLocalCachingSimpleLinkManager.class.getName() + ".getNonEmptySectionsForLocation";

    public ThreadLocalCachingSimpleLinkManager(DynamicWebInterfaceManager webInterfaceManager, SimpleLinkFactoryModuleDescriptors simpleLinkFactoryModuleDescriptors, JiraAuthenticationContext authenticationContext, JiraProperties jiraProperties, WebResourceUrlProvider webResourceUrlProvider, VelocityRequestContextFactory velocityRequestContextFactory) {
        super(webInterfaceManager, simpleLinkFactoryModuleDescriptors, authenticationContext, jiraProperties, webResourceUrlProvider, velocityRequestContextFactory);
    }

    @Override
    public boolean shouldLocationBeLazy(@Nonnull String location, ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper) {
        LoadingCache cache = (LoadingCache)JiraAuthenticationContextImpl.getRequestCache(LAZY_LOCATION_KEY, () -> CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, Boolean>(){

            public Boolean load(@Nonnull CacheKey key) throws Exception {
                return ThreadLocalCachingSimpleLinkManager.super.shouldLocationBeLazy(key.location, key.remoteUser, key.jiraHelper);
            }
        }));
        return (Boolean)cache.getUnchecked((Object)new CacheKey(location, remoteUser, jiraHelper));
    }

    @Override
    public boolean shouldSectionBeLazy(String section) {
        LoadingCache cache = (LoadingCache)JiraAuthenticationContextImpl.getRequestCache(LAZY_SECTION_KEY, () -> CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Boolean>(){

            public Boolean load(@Nonnull String key) throws Exception {
                return ThreadLocalCachingSimpleLinkManager.super.shouldSectionBeLazy(key);
            }
        }));
        return (Boolean)cache.getUnchecked((Object)section);
    }

    @Override
    @Nonnull
    public List<SimpleLink> getLinksForSection(@Nonnull String section, ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper) {
        return this.getLinksForSection(section, remoteUser, jiraHelper, false);
    }

    @Override
    @Nonnull
    public List<SimpleLink> getLinksForSection(@Nonnull String section, ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper, boolean addIconCachingPrefix) {
        LoadingCache cache = (LoadingCache)JiraAuthenticationContextImpl.getRequestCache(LINKS_FOR_SECTION_KEY, () -> CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<SimpleLink>>(){

            public List<SimpleLink> load(@Nonnull CacheKey key) throws Exception {
                return ThreadLocalCachingSimpleLinkManager.super.getLinksForSection(key.location, key.remoteUser, key.jiraHelper, key.addIconPrefix);
            }
        }));
        return (List)cache.getUnchecked((Object)new CacheKey(section, remoteUser, jiraHelper, addIconCachingPrefix));
    }

    @Override
    @Nonnull
    public List<SimpleLink> getLinksForSectionIgnoreConditions(@Nonnull String section, ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper) {
        LoadingCache cache = (LoadingCache)JiraAuthenticationContextImpl.getRequestCache(LINKS_FOR_SECTION_IC_KEY, () -> CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<SimpleLink>>(){

            public List<SimpleLink> load(@Nonnull CacheKey key) throws Exception {
                return ThreadLocalCachingSimpleLinkManager.super.getLinksForSectionIgnoreConditions(key.location, key.remoteUser, key.jiraHelper);
            }
        }));
        return (List)cache.getUnchecked((Object)new CacheKey(section, remoteUser, jiraHelper));
    }

    @Override
    @Nonnull
    public List<SimpleLinkSection> getSectionsForLocation(@Nonnull String location, ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper) {
        LoadingCache cache = (LoadingCache)JiraAuthenticationContextImpl.getRequestCache(SECTIONS_FOR_LOCATION_KEY, () -> CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<SimpleLinkSection>>(){

            public List<SimpleLinkSection> load(@Nonnull CacheKey key) throws Exception {
                return ThreadLocalCachingSimpleLinkManager.super.getSectionsForLocation(key.location, key.remoteUser, key.jiraHelper);
            }
        }));
        return (List)cache.getUnchecked((Object)new CacheKey(location, remoteUser, jiraHelper));
    }

    @Override
    public SimpleLinkSection getSectionForURL(@Nonnull String topLevelSection, @Nonnull String URL2, ApplicationUser remoteUser, JiraHelper jiraHelper) {
        return super.getSectionForURL(topLevelSection, URL2, remoteUser, jiraHelper);
    }

    @Override
    @Nonnull
    public List<SimpleLinkSection> getNotEmptySectionsForLocation(@Nonnull String location, ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper) {
        LoadingCache cache = (LoadingCache)JiraAuthenticationContextImpl.getRequestCache(NE_SECTIONS_FOR_LOCATION_KEY, () -> CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<SimpleLinkSection>>(){

            public List<SimpleLinkSection> load(@Nonnull CacheKey key) throws Exception {
                return ThreadLocalCachingSimpleLinkManager.super.getNotEmptySectionsForLocation(key.location, key.remoteUser, key.jiraHelper);
            }
        }));
        return (List)cache.getUnchecked((Object)new CacheKey(location, remoteUser, jiraHelper));
    }

    protected static class CacheKey {
        @Nonnull
        private final String location;
        @Nullable
        private final ApplicationUser remoteUser;
        @Nonnull
        private final JiraHelper jiraHelper;
        @Nullable
        private final Boolean addIconPrefix;
        private final int hash;

        public CacheKey(@Nonnull String location, @Nullable ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper) {
            this(location, remoteUser, jiraHelper, null);
        }

        public CacheKey(@Nonnull String location, @Nullable ApplicationUser remoteUser, @Nonnull JiraHelper jiraHelper, @Nullable Boolean addIconPrefix) {
            this.location = location;
            this.remoteUser = remoteUser;
            this.jiraHelper = jiraHelper;
            this.addIconPrefix = addIconPrefix;
            this.hash = this.calculateHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.addIconPrefix != null ? !this.addIconPrefix.equals(cacheKey.addIconPrefix) : cacheKey.addIconPrefix != null) {
                return false;
            }
            if (!this.jiraHelper.equals((Object)cacheKey.jiraHelper)) {
                return false;
            }
            if (!this.location.equals(cacheKey.location)) {
                return false;
            }
            return !(this.remoteUser != null ? !this.remoteUser.equals((Object)cacheKey.remoteUser) : cacheKey.remoteUser != null);
        }

        public int hashCode() {
            return this.hash;
        }

        protected int calculateHashCode() {
            int result = this.location.hashCode();
            result = 31 * result + (this.remoteUser != null ? this.remoteUser.hashCode() : 0);
            result = 31 * result + this.jiraHelper.hashCode();
            result = 31 * result + (this.addIconPrefix != null ? this.addIconPrefix.hashCode() : 0);
            return result;
        }
    }
}

