/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProviderImpl;
import io.atlassian.util.concurrent.LazyReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraWebResourceUrlProvider
extends WebResourceUrlProviderImpl {
    private static final Logger log = LoggerFactory.getLogger(JiraWebResourceUrlProvider.class);
    @VisibleForTesting
    static final String CDN_STATIC_PREFIX_PROPERTY = "jira.cdn.static.prefix";
    private final LazyReference<String> staticBaseUrlRef;

    public JiraWebResourceUrlProvider(ApplicationProperties applicationProperties, WebResourceIntegration webResourceIntegration) {
        super(webResourceIntegration);
        this.staticBaseUrlRef = JiraWebResourceUrlProvider.lazyLoadCdnStaticPrefix(applicationProperties);
    }

    private static LazyReference<String> lazyLoadCdnStaticPrefix(final ApplicationProperties applicationProperties) {
        return new LazyReference<String>(){

            protected String create() {
                String cdn = applicationProperties.getDefaultBackedString(JiraWebResourceUrlProvider.CDN_STATIC_PREFIX_PROPERTY);
                if (cdn != null) {
                    cdn = StringUtils.stripEnd((String)cdn, (String)"/");
                    log.info("CDN static prefix in use, prefix={}", (Object)cdn);
                }
                return cdn;
            }
        };
    }

    public String getStaticResourcePrefix(String resourceCounter, UrlMode urlMode) {
        String staticBaseUrl = (String)this.staticBaseUrlRef.get();
        if (staticBaseUrl != null) {
            return staticBaseUrl + super.getStaticResourcePrefix(resourceCounter, UrlMode.RELATIVE);
        }
        return super.getStaticResourcePrefix(resourceCounter, urlMode);
    }

    public String getStaticResourcePrefix(UrlMode urlMode) {
        String staticBaseUrl = (String)this.staticBaseUrlRef.get();
        if (staticBaseUrl != null) {
            return staticBaseUrl + super.getStaticResourcePrefix(UrlMode.RELATIVE);
        }
        return super.getStaticResourcePrefix(urlMode);
    }
}

