/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webwork;

import javax.servlet.http.HttpServletRequest;

public class ActionNameCleaner {
    private static final String ACTION_EXTENSION = ".jspa";

    public static String getActionName(HttpServletRequest httpServletRequest) {
        String servletPath = ActionNameCleaner.getServletPath(httpServletRequest);
        int beginIdx = ActionNameCleaner.getActionPathSegmentIdx(servletPath);
        int endIdx = ActionNameCleaner.getExtensionIdx(servletPath);
        return servletPath.substring(beginIdx == -1 ? 0 : beginIdx + 1, endIdx == -1 ? servletPath.length() : endIdx);
    }

    public static String getActionLastUrlSegment(HttpServletRequest httpServletRequest) {
        String servletPath = ActionNameCleaner.getServletPath(httpServletRequest);
        int beginIdx = ActionNameCleaner.getActionPathSegmentIdx(servletPath);
        int endIdx = ActionNameCleaner.getExtensionIdx(servletPath);
        return servletPath.substring(beginIdx == -1 ? 0 : beginIdx, endIdx == -1 ? servletPath.length() : endIdx + ACTION_EXTENSION.length());
    }

    private static String getServletPath(HttpServletRequest httpServletRequest) {
        String servletPath = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = httpServletRequest.getServletPath();
        }
        return servletPath;
    }

    private static int getExtensionIdx(String servletPath) {
        return servletPath.lastIndexOf(ACTION_EXTENSION);
    }

    private static int getActionPathSegmentIdx(String servletPath) {
        return servletPath.lastIndexOf("/");
    }
}

