/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.type;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.application.api.PlatformApplication;
import com.atlassian.application.host.plugin.PluginApplicationMetaDataManager;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationRoleDefinitions;
import com.atlassian.jira.application.JiraApplication;
import com.atlassian.jira.application.JiraPluginApplicationMetaData;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.user.ApplicationUser;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class JiraApplicationAdapter {
    private static final ProjectTypeKey BUSINESS_KEY = new ProjectTypeKey("business");
    private static final String BUSINESS_DESC = "jira.project.type.business.description";
    private static final String BUSINESS_ICON = "PHN2ZyB2ZXJzaW9uPSIxIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA3MSA3MSI+PGNpcmNsZSBjeD0iMzUuNSIgY3k9IjM1LjUiIHI9IjM1LjUiIGZpbGw9IiMwMDY1ZmYiLz48cGF0aCBkPSJNMTguNyAzNy41aDMzLjVjMS42IDAgMyAxLjMgMyAzcy0xLjMgMy0zIDNIMTguN2MtMS42IDAtMy0xLjMtMy0zczEuNC0zIDMtM3ptMC05LjloMzMuNWMxLjYgMCAzIDEuMyAzIDMgMCAxLjYtMS4zIDMtMyAzSDE4LjdjLTEuNiAwLTMtMS4zLTMtMyAuMS0xLjcgMS40LTMgMy0zem0wLTkuOGgzMy41YzEuNiAwIDMgMS4zIDMgM3MtMS4zIDMtMyAzSDE4LjdjLTEuNiAwLTMtMS4zLTMtM3MxLjQtMyAzLTN6bS4xIDI5LjVoMTcuN2MxLjcgMCAzIDEuMyAzIDNzLTEuMyAzLTMgM0gxOC44Yy0xLjcgMC0zLTEuMy0zLTMgMC0xLjYgMS4zLTMgMy0zeiIgZmlsbD0iI2ZmZiIvPjwvc3ZnPg==";
    private static final String BUSINESS_COLOR = "#0065FF";
    private static final int BUSINESS_WEIGHT = 1000;
    static final ProjectType BUSINESS_TYPE = new ProjectType(BUSINESS_KEY, "jira.project.type.business.description", "PHN2ZyB2ZXJzaW9uPSIxIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA3MSA3MSI+PGNpcmNsZSBjeD0iMzUuNSIgY3k9IjM1LjUiIHI9IjM1LjUiIGZpbGw9IiMwMDY1ZmYiLz48cGF0aCBkPSJNMTguNyAzNy41aDMzLjVjMS42IDAgMyAxLjMgMyAzcy0xLjMgMy0zIDNIMTguN2MtMS42IDAtMy0xLjMtMy0zczEuNC0zIDMtM3ptMC05LjloMzMuNWMxLjYgMCAzIDEuMyAzIDMgMCAxLjYtMS4zIDMtMyAzSDE4LjdjLTEuNiAwLTMtMS4zLTMtMyAuMS0xLjcgMS40LTMgMy0zem0wLTkuOGgzMy41YzEuNiAwIDMgMS4zIDMgM3MtMS4zIDMtMyAzSDE4LjdjLTEuNiAwLTMtMS4zLTMtM3MxLjQtMyAzLTN6bS4xIDI5LjVoMTcuN2MxLjcgMCAzIDEuMyAzIDNzLTEuMyAzLTMgM0gxOC44Yy0xLjcgMC0zLTEuMy0zLTMgMC0xLjYgMS4zLTMgMy0zeiIgZmlsbD0iI2ZmZiIvPjwvc3ZnPg==", "#0065FF", 1000);
    public final ApplicationManager applicationManager;
    public final PluginApplicationMetaDataManager metaDataManager;
    public final ApplicationAuthorizationService applicationAuthorizationService;
    private final ApplicationRoleDefinitions applicationRoleDefinitions;

    public JiraApplicationAdapter(ApplicationManager applicationManager, PluginApplicationMetaDataManager metaDataManager, ApplicationAuthorizationService applicationAuthorizationService, ApplicationRoleDefinitions applicationRoleDefinitions) {
        this.applicationManager = applicationManager;
        this.metaDataManager = metaDataManager;
        this.applicationAuthorizationService = applicationAuthorizationService;
        this.applicationRoleDefinitions = applicationRoleDefinitions;
    }

    public Iterable<JiraApplication> getJiraApplications() {
        return (Iterable)this.buildJiraApplications().collect(CollectorsUtil.toImmutableList());
    }

    public Iterable<JiraApplication> getAccessibleJiraApplications() {
        boolean atLeastOneNonCoreApplicationLicensed = this.isAtLeastOneNonCoreApplicationLicensed();
        return (Iterable)this.buildJiraApplications().filter(application -> atLeastOneNonCoreApplicationLicensed && this.isPlatformApplication((JiraApplication)application) || this.applicationAuthorizationService.isApplicationInstalledAndLicensed(application.getKey())).collect(CollectorsUtil.toImmutableList());
    }

    public Iterable<JiraApplication> getAccessibleJiraApplications(ApplicationUser user) {
        return (Iterable)this.buildJiraApplications().filter(application -> this.applicationAuthorizationService.canUseApplication(user, application.getKey())).collect(CollectorsUtil.toImmutableList());
    }

    private boolean isPlatformApplication(JiraApplication application) {
        return application.getKey().equals((Object)this.applicationManager.getPlatform().getKey());
    }

    private boolean isAtLeastOneNonCoreApplicationLicensed() {
        Stream<ApplicationRoleDefinitions.ApplicationRoleDefinition> licensedDefinitions = StreamSupport.stream(this.applicationRoleDefinitions.getLicensed().spliterator(), false);
        return licensedDefinitions.anyMatch(this::isNonCoreApplicationDefinition);
    }

    private boolean isNonCoreApplicationDefinition(ApplicationRoleDefinitions.ApplicationRoleDefinition definition) {
        return !this.applicationManager.getPlatform().getKey().equals((Object)definition.key());
    }

    private Stream<JiraApplication> buildJiraApplications() {
        return Stream.concat(this.getJiraAppForPlatformApp(), this.getJiraAppsForNonPlatformApps());
    }

    private Stream<JiraApplication> getJiraAppForPlatformApp() {
        PlatformApplication platform = this.applicationManager.getPlatform();
        return Stream.of(new JiraApplication((Application)platform, Arrays.asList(BUSINESS_TYPE)));
    }

    private Stream<JiraApplication> getJiraAppsForNonPlatformApps() {
        return this.getNonPlatformApplications().flatMap(this::getJiraApplicationFor);
    }

    private Stream<Application> getNonPlatformApplications() {
        Stream<Application> applications = StreamSupport.stream(this.applicationManager.getApplications().spliterator(), false);
        return applications.filter(input -> !(input instanceof PlatformApplication));
    }

    private Stream<JiraApplication> getJiraApplicationFor(Application application) {
        return (Stream)this.getMetadataForApplication(application.getKey()).map(meta -> new JiraApplication(application, meta.getProjectTypes())).map(Stream::of).getOrElse(Stream.empty());
    }

    private Option<JiraPluginApplicationMetaData> getMetadataForApplication(ApplicationKey appKey) {
        return Option.option((Object)this.metaDataManager.getApplication(appKey).getOrNull()).map(JiraPluginApplicationMetaData.class::cast);
    }
}

