/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.database.SqlCallback;
import com.atlassian.jira.model.querydsl.JiraRelationalPathBase;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyText;
import com.atlassian.jira.propertyset.NoOpPropertyEntryStoreStats;
import com.atlassian.jira.propertyset.OfBizPropertyEntryStore;
import com.atlassian.jira.propertyset.OfBizPropertyTypeRegistry;
import com.atlassian.jira.propertyset.PropertyEntryStoreStats;
import com.atlassian.jira.propertyset.TotalAndSnapshotPropertyEntryStoreStats;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLTransactionRollbackException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingOfBizPropertyEntryStore
implements OfBizPropertyEntryStore {
    private static final Logger LOG = LoggerFactory.getLogger(CachingOfBizPropertyEntryStore.class);
    static final int BATCH_SIZE = 900;
    private static final int MAX_ATTEMPTS = 5;
    private static final String SQLSTATE_INTEGRITY_ERROR_PREFIX = "23";
    private final QueryDslAccessor queryDslAccessor;
    private final Cache<CacheKey, PropertySetData> cache;
    private final PropertyEntryStoreStats stats;

    CachingOfBizPropertyEntryStore(String cacheName, QueryDslAccessor queryDslAccessor, CacheManager cacheManager, boolean enableStats) {
        this(cacheName, new CacheSettingsBuilder().expireAfterAccess(1L, TimeUnit.DAYS).flushable().build(), queryDslAccessor, cacheManager, enableStats);
    }

    CachingOfBizPropertyEntryStore(String cacheName, CacheSettings cacheSettings, QueryDslAccessor queryDslAccessor, CacheManager cacheManager, boolean enableStats) {
        this.queryDslAccessor = Objects.requireNonNull(queryDslAccessor, "queryDslAccessor");
        this.cache = cacheManager.getCache(cacheName, this::loadPropertySetData, cacheSettings);
        if (enableStats) {
            LOG.info("{} stats enabled: {}", (Object)cacheName, (Object)TotalAndSnapshotPropertyEntryStoreStats.class.getSimpleName());
            this.stats = new TotalAndSnapshotPropertyEntryStoreStats(cacheName);
        } else {
            LOG.info("{} stats disabled: {}", (Object)cacheName, (Object)NoOpPropertyEntryStoreStats.class.getSimpleName());
            this.stats = new NoOpPropertyEntryStoreStats();
        }
    }

    protected void validateEntityName(String entityName) {
    }

    PropertySetData resolve(String entityName, long entityId) {
        CacheKey cacheKey = new CacheKey(entityName, entityId);
        try {
            PropertySetData propertySetData = (PropertySetData)this.cache.get((Object)cacheKey);
            return propertySetData;
        }
        catch (RuntimeException re) {
            throw CachingOfBizPropertyEntryStore.propEx("Unable to load values for " + cacheKey, re);
        }
        finally {
            this.stats.onGetEntry(entityName, 0L);
        }
    }

    @Override
    @Nonnull
    public Collection<String> getKeys(String entityName, long entityId) {
        this.validateEntityName(entityName);
        return this.resolve(entityName, entityId).keys();
    }

    @Override
    @Nonnull
    public Collection<String> getKeys(String entityName, long entityId, int type) {
        this.validateEntityName(entityName);
        return this.resolve(entityName, entityId).keys(type);
    }

    @Override
    public OfBizPropertyEntryStore.PropertyEntry getEntry(String entityName, long entityId, String propertyKey) {
        this.validateEntityName(entityName);
        return this.resolve(entityName, entityId).get(propertyKey);
    }

    @Override
    public boolean exists(String entityName, long entityId, String propertyKey) {
        this.validateEntityName(entityName);
        return this.getType(entityName, entityId, propertyKey) > 0;
    }

    @Override
    public int getType(String entityName, long entityId, String propertyKey) {
        this.validateEntityName(entityName);
        return this.resolve(entityName, entityId).getType(propertyKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEntry(String entityName, long entityId, String propertyKey, int type, Object value) {
        this.validateEntityName(entityName);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            CachingOfBizPropertyEntryStore.retry(this.createSetOperation(entityName, entityId, propertyKey, type, value));
        }
        finally {
            this.stats.onSetEntry(entityName, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            this.invalidateCacheEntry(entityName, entityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(String entityName, long entityId, String propertyKey) {
        this.validateEntityName(entityName);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            CachingOfBizPropertyEntryStore.retry(this.createRemoveOperation(entityName, entityId, propertyKey));
        }
        finally {
            this.stats.onRemoveEntry(entityName, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            this.invalidateCacheEntry(entityName, entityId);
        }
    }

    protected Operation createRemoveOperation(String entityName, long entityId, String propertyKey) {
        return new RemoveOperation(entityName, entityId, propertyKey);
    }

    protected Operation createSetOperation(String entityName, long entityId, String propertyKey, int type, Object value) {
        return new SetOperation(entityName, entityId, propertyKey, type, value);
    }

    @Override
    public void removePropertySet(String entityName, long entityId) {
        this.validateEntityName(entityName);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.executeTx(db -> {
                List<Tuple> rows = this.loadIdsAndTypes(db, entityName, entityId);
                db.delete((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)entityName)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)entityId)).execute();
                CachingOfBizPropertyEntryStore.removeValues(db, rows);
            });
        }
        catch (QueryException qe) {
            throw CachingOfBizPropertyEntryStore.propEx(qe);
        }
        finally {
            this.stats.onRemoveEntry(entityName, stopwatch.elapsed(TimeUnit.MILLISECONDS));
            this.invalidateCacheEntry(entityName, entityId);
        }
    }

    static void removeValues(DbConnection db, List<Tuple> idsAndTypes) {
        CachingOfBizPropertyEntryStore.groupByValuePath(idsAndTypes).forEach((path, ids) -> CachingOfBizPropertyEntryStore.deleteById(db, path, ids));
    }

    private static Map<JiraRelationalPathBase<?>, List<Long>> groupByValuePath(List<Tuple> idsAndTypes) {
        IdentityHashMap idsByValueTable = new IdentityHashMap(4);
        idsAndTypes.forEach(idAndType -> {
            Long id = (Long)idAndType.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id);
            Integer type = (Integer)idAndType.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.type);
            try {
                JiraRelationalPathBase<?> path = OfBizPropertyTypeRegistry.mapper(type).getValueTable();
                idsByValueTable.computeIfAbsent(path, key -> new ArrayList()).add(id);
            }
            catch (PropertyImplementationException pie) {
                LOG.warn("Ignoring property entry with invalid type: id={}, type={}", (Object)id, (Object)type);
            }
        });
        return idsByValueTable;
    }

    private static void deleteById(DbConnection db, JiraRelationalPathBase<?> path, Collection<Long> ids) {
        ArrayList<Long> list = new ArrayList<Long>(ids);
        Lists.partition(list, (int)900).forEach(subList -> {
            try {
                db.delete((RelationalPath<?>)path).where((Predicate)path.getNumericIdPath().in((Collection)subList)).execute();
            }
            catch (QueryException qe) {
                LOG.warn("Unable to remove property set values from {}: {}", new Object[]{path.getSchemaAndTable(), ids, qe});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCacheEntry(String entityName, long entityId) {
        this.validateEntityName(entityName);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.cache.remove((Object)new CacheKey(entityName, entityId));
        }
        finally {
            this.stats.onInvalidateCache(entityName, stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    public void refreshAll() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.cache.removeAll();
        }
        finally {
            this.stats.onRemoveAll(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private List<Tuple> loadIdsAndTypes(DbConnection db, String entityName, long entityId) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.id, QOSPropertyEntry.O_S_PROPERTY_ENTRY.type}).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)entityName))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)entityId))).fetch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    PropertySetData loadPropertySetData(CacheKey cacheKey) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            PropertySetData propertySetData = new PropertySetData(cacheKey.entityName, cacheKey.entityId);
            return propertySetData;
        }
        finally {
            this.stats.onCacheMiss(cacheKey.entityName, stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private void execute(SqlCallback callback) {
        this.queryDslAccessor.withNewConnection().execute(callback);
    }

    private void executeTx(SqlCallback callback) {
        this.execute(db -> {
            db.setAutoCommit(false);
            callback.run(db);
            db.commit();
        });
    }

    private <T> T query(QueryCallback<T> callback) {
        return this.queryDslAccessor.withNewConnection().executeQuery(callback);
    }

    private <T> T queryTx(QueryCallback<T> callback) {
        return (T)this.query(db -> {
            db.setAutoCommit(false);
            Object result = callback.runQuery(db);
            db.commit();
            return result;
        });
    }

    private static void retry(Operation operation) {
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    if (!operation.perform()) continue;
                    return;
                }
                catch (QueryException qex) {
                    String state;
                    Throwable cause = qex.getCause();
                    if (cause instanceof SQLTransactionRollbackException) {
                        LOG.warn("Possible deadlock detected, retrying", (Throwable)qex);
                        continue;
                    }
                    if (cause instanceof SQLIntegrityConstraintViolationException) {
                        LOG.warn("Possible concurrent modification detected, retrying", (Throwable)qex);
                        continue;
                    }
                    if (cause instanceof SQLException && (state = ((SQLException)cause).getSQLState()).startsWith(SQLSTATE_INTEGRITY_ERROR_PREFIX)) {
                        LOG.warn("Possible concurrent modification detected, retrying", (Throwable)qex);
                        continue;
                    }
                    throw qex;
                }
            }
        }
        catch (RuntimeException re) {
            Throwables.propagateIfInstanceOf((Throwable)re, PropertyImplementationException.class);
            throw CachingOfBizPropertyEntryStore.propEx("Failed operation: " + operation, re);
        }
        throw new PropertyImplementationException("Failed operation (too many retries): " + operation);
    }

    private static PropertyImplementationException propEx(Throwable cause) {
        PropertyImplementationException ex = new PropertyImplementationException(cause);
        ex.initCause(cause);
        throw ex;
    }

    private static PropertyImplementationException propEx(String message, Throwable cause) {
        PropertyImplementationException ex = new PropertyImplementationException(message, cause);
        ex.initCause(cause);
        throw ex;
    }

    class RemoveOperation
    extends Operation {
        RemoveOperation(String entityName, long entityId, String propertyKey) {
            super(entityName, entityId, propertyKey);
        }

        @Override
        boolean perform() {
            return (Boolean)CachingOfBizPropertyEntryStore.this.queryTx(this::deleteEntryAndValue);
        }

        boolean deleteEntryAndValue(DbConnection db) {
            Tuple idAndType = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.id, QOSPropertyEntry.O_S_PROPERTY_ENTRY.type}).forUpdate()).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)this.entityName))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)this.entityId))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)this.propertyKey))).fetchOne();
            return idAndType == null || this.deleteEntriesAndValues(db, idAndType);
        }

        boolean deleteEntriesAndValues(DbConnection db, Tuple idAndType) {
            int type;
            long id = (Long)Objects.requireNonNull(idAndType.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id));
            if (!this.deleteEntry(db, id, type = ((Integer)Objects.requireNonNull(idAndType.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.type))).intValue())) {
                LOG.warn("SELECT FOR UPDATE is broken.  operation={}", (Object)this);
                return false;
            }
            CachingOfBizPropertyEntryStore.removeValues(db, Collections.singletonList(idAndType));
            return true;
        }

        boolean deleteEntry(DbConnection db, long id, int type) {
            return db.delete((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq((Object)id)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.type.eq((Object)type)).execute() > 0L;
        }

        @Override
        public String toString() {
            return "RemoveOperation[entityName=" + this.entityName + ",entityId=" + this.entityId + ",propertyKey=" + this.propertyKey + ']';
        }
    }

    class SetOperation
    extends Operation {
        private final int newType;
        private final OfBizPropertyTypeRegistry.TypeMapper newMapper;
        private final Object mappedValue;

        SetOperation(String entityName, long entityId, String propertyKey, @Nullable int type, Object unmappedValue) {
            super(entityName, entityId, propertyKey);
            this.newType = type;
            this.newMapper = OfBizPropertyTypeRegistry.mapper(type);
            this.mappedValue = unmappedValue != null ? OfBizPropertyTypeRegistry.mapper(type).getHandler().processSet(type, unmappedValue) : null;
        }

        @Override
        boolean perform() {
            return (Boolean)CachingOfBizPropertyEntryStore.this.queryTx(this::upsert);
        }

        private boolean upsert(DbConnection db) {
            Tuple existingIdAndType = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.id, QOSPropertyEntry.O_S_PROPERTY_ENTRY.type}).forUpdate()).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)this.entityName))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)this.entityId))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)this.propertyKey))).fetchOne();
            return existingIdAndType != null ? this.update(db, existingIdAndType) : this.insert(db);
        }

        private boolean insert(DbConnection db) {
            long id = db.insert(QOSPropertyEntry.O_S_PROPERTY_ENTRY).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName, this.entityName).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId, (Object)this.entityId).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey, this.propertyKey).set((Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.type, (Object)this.newType).executeWithId();
            this.newMapper.insert(db, id, this.mappedValue);
            return true;
        }

        private boolean update(DbConnection db, Tuple idAndType) {
            Long id = (Long)Objects.requireNonNull(idAndType.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.id), "id");
            int oldType = (Integer)Objects.requireNonNull(idAndType.get(QOSPropertyEntry.O_S_PROPERTY_ENTRY.type), "type");
            return oldType != this.newType ? this.updateTypeAndValue(db, id, oldType) : this.upsertValue(db, id);
        }

        private boolean updateTypeAndValue(DbConnection db, long id, int oldType) {
            if (!this.updateType(db, id, oldType)) {
                LOG.warn("SELECT FOR UPDATE is broken: operation={}; oldType={}", (Object)this, (Object)oldType);
                return false;
            }
            OfBizPropertyTypeRegistry.TypeMapper oldMapper = OfBizPropertyTypeRegistry.mapper(oldType);
            return this.newMapper.hasSameEntityName(oldMapper) ? this.upsertValue(db, id) : this.moveValue(db, id, oldMapper);
        }

        private boolean moveValue(DbConnection db, Long id, OfBizPropertyTypeRegistry.TypeMapper oldMapper) {
            oldMapper.delete(db, id);
            this.newMapper.insert(db, id, this.mappedValue);
            return true;
        }

        private boolean updateType(DbConnection db, long id, int oldType) {
            return db.update((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).set(QOSPropertyEntry.O_S_PROPERTY_ENTRY.type, (Object)this.newType).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq((Object)id)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.type.eq((Object)oldType)).execute() > 0L;
        }

        private boolean upsertValue(DbConnection db, Long id) {
            return this.newMapper.upsert(db, id, this.mappedValue);
        }

        @Override
        public String toString() {
            return "SetOperation[entityName=" + this.entityName + ",entityId=" + this.entityId + ",propertyKey=" + this.propertyKey + ",newType=" + this.newType + ",newMapper=" + this.newMapper + ']';
        }
    }

    static abstract class Operation {
        final String entityName;
        final long entityId;
        final String propertyKey;

        protected Operation(String entityName, long entityId, String propertyKey) {
            this.entityName = entityName;
            this.entityId = entityId;
            this.propertyKey = propertyKey;
        }

        abstract boolean perform();

        public abstract String toString();
    }

    class PropertySetData {
        private final String entityName;
        private final long entityId;
        private final Map<String, Integer> keysAndTypes;
        private final Map<String, Map<String, Object>> valuesByMapperEntityName = new ConcurrentHashMap<String, Map<String, Object>>(4);
        private final Map<String, Optional<String>> textValuesCache = new ConcurrentHashMap<String, Optional<String>>();

        PropertySetData(String entityName, long entityId) {
            this.entityName = entityName;
            this.entityId = entityId;
            this.keysAndTypes = this.loadPropertyKeysAndTypes(entityName, entityId);
        }

        Set<String> keys() {
            return this.keysAndTypes.keySet();
        }

        Set<String> keys(int type) {
            return (Set)this.keysAndTypes.entrySet().stream().filter(entry -> type == (Integer)entry.getValue()).map(Map.Entry::getKey).collect(CollectorsUtil.toImmutableSet());
        }

        int getType(String key) {
            Integer type = this.keysAndTypes.get(key);
            return type != null ? type : 0;
        }

        @Nullable
        OfBizPropertyEntryStore.PropertyEntry get(String key) {
            Integer type = this.keysAndTypes.get(key);
            return type != null ? this.get(key, type) : null;
        }

        private OfBizPropertyEntryStore.PropertyEntry get(String key, int type) {
            OfBizPropertyTypeRegistry.TypeMapper mapper = OfBizPropertyTypeRegistry.mapper(type);
            if (type == 6) {
                return this.textValuesCache.computeIfAbsent(key, this::getText).map(value -> new PropertyEntryImpl(6, value)).orElse(null);
            }
            return new PropertyEntryImpl(type, this.bulkLoad(mapper).get(key));
        }

        private Map<String, Integer> loadPropertyKeysAndTypes(String entityName, long entityId) {
            List rows = (List)CachingOfBizPropertyEntryStore.this.query(db -> ((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey, QOSPropertyEntry.O_S_PROPERTY_ENTRY.type}).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)entityName))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)entityId))).fetch());
            return this.asMap(rows, (Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY.type);
        }

        private Optional<String> getText(String key) {
            String value = (String)CachingOfBizPropertyEntryStore.this.query(db -> (String)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select((Expression)QOSPropertyText.O_S_PROPERTY_TEXT.value).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).join((EntityPath)QOSPropertyText.O_S_PROPERTY_TEXT)).on((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq(QOSPropertyText.O_S_PROPERTY_TEXT.id))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)this.entityName))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)this.entityId))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.eq((Object)key))).fetchOne());
            return Optional.ofNullable(value).map(StringUtils::defaultString);
        }

        private Map<String, Object> bulkLoad(OfBizPropertyTypeRegistry.TypeMapper mapper) {
            return this.valuesByMapperEntityName.computeIfAbsent(mapper.getValueEntity(), mapperEntityName -> this.loadValues(this.entityName, this.entityId, mapper));
        }

        private Map<String, Object> loadValues(String entityName, long entityId, OfBizPropertyTypeRegistry.TypeMapper mapper) {
            List rows = (List)CachingOfBizPropertyEntryStore.this.query(db -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey, mapper.getValuePath()}).from((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).join(mapper.getValueTable())).on((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq(mapper.getValueTable().getNumericIdPath()))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)entityName))).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId.eq((Object)entityId))).fetch());
            return this.asMap(rows, mapper.getValuePath());
        }

        private <T> Map<String, T> asMap(List<Tuple> rows, Path<? extends T> valuePath) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)rows.size());
            rows.forEach(row -> map.computeIfAbsent(row.get((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey), ignored -> row.get((Expression)valuePath)));
            return map;
        }
    }

    static class PropertyEntryImpl
    implements OfBizPropertyEntryStore.PropertyEntry {
        private final int type;
        private final Object value;

        PropertyEntryImpl(int type, @Nullable Object value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        @Nullable
        public Object getValue() {
            if (this.value == null) {
                return null;
            }
            return OfBizPropertyTypeRegistry.mapper(this.type).getHandler().processGet(this.type, this.value);
        }

        @Override
        @Nullable
        public Object getValue(int type) {
            if (this.value == null) {
                return null;
            }
            return OfBizPropertyTypeRegistry.mapper(type).getHandler().processGet(type, this.value);
        }

        public String toString() {
            return "PropertyEntryImpl[type=" + this.type + ",value=" + this.value + ']';
        }
    }

    static final class CacheKey
    implements Serializable {
        private static final long serialVersionUID = 4729043221678305211L;
        private final String entityName;
        private final long entityId;

        CacheKey(String entityName, long entityId) {
            this.entityName = entityName;
            this.entityId = entityId;
        }

        String getEntityName() {
            return this.entityName;
        }

        long getEntityId() {
            return this.entityId;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof CacheKey && this.equals((CacheKey)o);
        }

        private boolean equals(@Nonnull CacheKey other) {
            return this.entityId == other.entityId && this.entityName.equals(other.entityName);
        }

        public int hashCode() {
            int result = this.entityName.hashCode();
            result = 31 * result + (int)(this.entityId ^ this.entityId >>> 32);
            return result;
        }

        public String toString() {
            return "CacheKey[entityName=" + this.entityName + ",entityId=" + this.entityId + ']';
        }
    }
}

