/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.propertyset.PropertyEntryStoreStats;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.math.LongMath;
import com.google.gson.Gson;
import java.math.RoundingMode;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TotalAndSnapshotPropertyEntryStoreStats
implements PropertyEntryStoreStats {
    private static final Logger log = LoggerFactory.getLogger(TotalAndSnapshotPropertyEntryStoreStats.class);
    private static final String LOG_PREFIX = "[OFBIZ-PROPERTY-ENTRY-STORE-STATS] ";
    private static final String SYSTEM_PROPERTY_PRINT_STATS_MAX_SIZE = "com.atlassian.jira.propertyset.stats.max.size";
    private final String cacheName;
    private final MutablePropertyEntryStoreStats snapshotStats = new MutablePropertyEntryStoreStats();
    private final MutablePropertyEntryStoreStats totalStats = new MutablePropertyEntryStoreStats();
    private final AtomicReference<Long> createdTimestamp;
    private final AtomicReference<Long> lastPrintStatsTimestamp;
    private final Clock clock;
    private final long printStatsMinPeriodInMillis;

    public TotalAndSnapshotPropertyEntryStoreStats(String cacheName) {
        this(cacheName, Clock.systemUTC());
    }

    public TotalAndSnapshotPropertyEntryStoreStats(String cacheName, Clock clock) {
        this.cacheName = cacheName;
        this.clock = clock;
        Long now = clock.millis();
        this.createdTimestamp = new AtomicReference<Long>(now);
        this.lastPrintStatsTimestamp = new AtomicReference<Long>(now);
        this.printStatsMinPeriodInMillis = JiraStats.statsLoggingInterval((TimeUnit)TimeUnit.MILLISECONDS);
        log.debug(this.getLogPrefix() + "stats will be running every: {} millis", (Object)this.printStatsMinPeriodInMillis);
    }

    private String getLogPrefix() {
        return "[OFBIZ-PROPERTY-ENTRY-STORE-STATS] [" + this.cacheName + "] ";
    }

    @Override
    public void onGetEntry(String entityName, long elapsed) {
        this.snapshotStats.onGetEntry(entityName, elapsed);
        this.totalStats.onGetEntry(entityName, elapsed);
    }

    @Override
    public void onSetEntry(String entityName, long elapsed) {
        this.snapshotStats.onSetEntry(entityName, elapsed);
        this.totalStats.onSetEntry(entityName, elapsed);
        this.printAndSendStatsNotTooOften();
    }

    @Override
    public void onRemoveEntry(String entityName, long elapsed) {
        this.snapshotStats.onRemoveEntry(entityName, elapsed);
        this.totalStats.onRemoveEntry(entityName, elapsed);
        this.printAndSendStatsNotTooOften();
    }

    @Override
    public void onCacheMiss(String entityName, long elapsed) {
        this.snapshotStats.onCacheMiss(entityName, elapsed);
        this.totalStats.onCacheMiss(entityName, elapsed);
        this.printAndSendStatsNotTooOften();
    }

    @Override
    public void onInvalidateCache(String entityName, long elapsed) {
        this.snapshotStats.onInvalidateCache(entityName, elapsed);
        this.totalStats.onInvalidateCache(entityName, elapsed);
        this.printAndSendStatsNotTooOften();
    }

    @Override
    public void onRemoveAll(long elapsed) {
        this.snapshotStats.onRemoveAll(elapsed);
        this.totalStats.onRemoveAll(elapsed);
        this.printAndSendStatsNotTooOften();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printAndSendStatsNotTooOften() {
        if (this.canPrintStats()) {
            TotalAndSnapshotPropertyEntryStoreStats totalAndSnapshotPropertyEntryStoreStats = this;
            synchronized (totalAndSnapshotPropertyEntryStoreStats) {
                if (this.canPrintStats()) {
                    this.printStats();
                }
            }
        }
    }

    private boolean canPrintStats() {
        return this.clock.millis() - this.lastPrintStatsTimestamp.get() >= this.printStatsMinPeriodInMillis;
    }

    @VisibleForTesting
    static long getTopNStatsSize() {
        return JiraSystemProperties.getInstance().getLong(SYSTEM_PROPERTY_PRINT_STATS_MAX_SIZE, Long.valueOf(5L));
    }

    private synchronized void printStats() {
        long now = this.clock.millis();
        long prev = this.lastPrintStatsTimestamp.getAndSet(now);
        ImmutablePropertyEntryStoreStats snapshotResult = this.snapshotStats.get();
        this.snapshotStats.reset();
        ImmutablePropertyEntryStoreStats totalResult = this.totalStats.get();
        log.info("[JIRA-STATS] " + this.getLogPrefix() + "total stats period: {}, data: {}", (Object)Duration.ofMillis(now - this.createdTimestamp.get()), (Object)totalResult);
        log.info("[JIRA-STATS] " + this.getLogPrefix() + "snapshot stats period: {}, data: {}", (Object)Duration.ofMillis(now - prev), (Object)snapshotResult);
    }

    private static final class MutablePropertyEntryStoreStats
    implements PropertyEntryStoreStats {
        private final ConcurrentHashMap<String, MutableLongStats> getEntry = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, MutableLongStats> setEntry = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, MutableLongStats> removeEntry = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, MutableLongStats> cacheMiss = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, MutableLongStats> invalidateCache = new ConcurrentHashMap();
        private final MutableLongStats removeAll = MutablePropertyEntryStoreStats.newMutableLongStats();

        private MutablePropertyEntryStoreStats() {
        }

        @Override
        public void onGetEntry(String entityName, long elapsed) {
            this.markOccurrence(this.getEntry, entityName, elapsed);
        }

        @Override
        public void onSetEntry(String entityName, long elapsed) {
            this.markOccurrence(this.setEntry, entityName, elapsed);
        }

        @Override
        public void onRemoveEntry(String entityName, long elapsed) {
            this.markOccurrence(this.removeEntry, entityName, elapsed);
        }

        @Override
        public void onCacheMiss(String entityName, long elapsed) {
            this.markOccurrence(this.cacheMiss, entityName, elapsed);
        }

        @Override
        public void onInvalidateCache(String entityName, long elapsed) {
            this.markOccurrence(this.invalidateCache, entityName, elapsed);
        }

        @Override
        public void onRemoveAll(long elapsed) {
            this.removeAll.accept(elapsed);
        }

        private void markOccurrence(ConcurrentHashMap<String, MutableLongStats> entityNameToCount, String entityName, long elapsed) {
            MutableLongStats counter = entityNameToCount.get(entityName);
            if (counter == null) {
                entityNameToCount.computeIfAbsent(entityName, ignore -> MutablePropertyEntryStoreStats.newMutableLongStats()).accept(elapsed);
            } else {
                counter.accept(elapsed);
            }
        }

        private static MutableLongStats newMutableLongStats() {
            return new MutableLongStats(new long[0]);
        }

        public ImmutablePropertyEntryStoreStats get() {
            return new ImmutablePropertyEntryStoreStats(this, TotalAndSnapshotPropertyEntryStoreStats.getTopNStatsSize());
        }

        public void reset() {
            Stream.of(this.getEntry, this.setEntry, this.removeEntry, this.cacheMiss, this.invalidateCache).map(Map::values).flatMap(Collection::stream).forEach(MutableLongStats::reset);
            this.removeAll.reset();
        }
    }

    private static final class ImmutablePropertyEntryStoreStats {
        private static final Gson GSON = new Gson();
        private final ImmutableMap<String, LongStatsWithTotalPct> getEntry;
        private final ImmutableMap<String, LongStatsWithTotalPct> setEntry;
        private final ImmutableMap<String, LongStatsWithTotalPct> removeEntry;
        private final ImmutableMap<String, LongStatsWithTotalPct> cacheMiss;
        private final ImmutableMap<String, LongStatsWithTotalPct> invalidateCache;
        @Nullable
        private final LongStats removeAll;

        public ImmutablePropertyEntryStoreStats(MutablePropertyEntryStoreStats mutablePropertyEntryStoreStats, long limit) {
            this.getEntry = this.getTopN(this.toImmutableMap(mutablePropertyEntryStoreStats.getEntry), limit);
            this.setEntry = this.getTopN(this.toImmutableMap(mutablePropertyEntryStoreStats.setEntry), limit);
            this.removeEntry = this.getTopN(this.toImmutableMap(mutablePropertyEntryStoreStats.removeEntry), limit);
            this.cacheMiss = this.getTopN(this.toImmutableMap(mutablePropertyEntryStoreStats.cacheMiss), limit);
            this.invalidateCache = this.getTopN(this.toImmutableMap(mutablePropertyEntryStoreStats.invalidateCache), limit);
            LongStats removeAll = mutablePropertyEntryStoreStats.removeAll.get();
            this.removeAll = removeAll.count() > 0L ? removeAll : null;
        }

        private ImmutableMap<String, LongStats> toImmutableMap(Map<String, MutableLongStats> input) {
            return (ImmutableMap)input.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((MutableLongStats)e.getValue()).get()));
        }

        private ImmutableMap<String, LongStatsWithTotalPct> getTopN(ImmutableMap<String, LongStats> input, long limit) {
            long allEntitiesCount = this.aggregateAllEntities((Map<String, LongStats>)input, LongStats::count);
            long allEntitiesSum = this.aggregateAllEntities((Map<String, LongStats>)input, LongStats::sum);
            return (ImmutableMap)input.entrySet().stream().filter(e -> ((LongStats)e.getValue()).count() > 0L).sorted(Comparator.comparing(e -> ((LongStats)e.getValue()).count()).reversed().thenComparing(Map.Entry::getKey)).limit(limit).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> new LongStatsWithTotalPct((LongStats)e.getValue(), allEntitiesCount, allEntitiesSum)));
        }

        private long aggregateAllEntities(Map<String, LongStats> input, Function<LongStats, Long> longStatsMapFunction) {
            return input.values().stream().map(longStatsMapFunction).mapToLong(Long::longValue).sum();
        }

        public String toString() {
            return GSON.toJson((Object)this);
        }

        private static class LongStatsWithTotalPct
        extends LongStats {
            private final long pctOfTotalCount;
            private final long pctOfTotalSum;

            private LongStatsWithTotalPct(LongStats longStats, long allEntitiesTotalCount, long allEntitiesTotalSum) {
                super(longStats.count, longStats.min, longStats.max, longStats.sum, (Map)longStats.distributionCounter);
                this.pctOfTotalCount = LongStatsWithTotalPct.toPct(longStats.count, allEntitiesTotalCount);
                this.pctOfTotalSum = LongStatsWithTotalPct.toPct(longStats.sum, allEntitiesTotalSum);
            }

            private static long toPct(long dividend, long divisor) {
                if (divisor == 0L) {
                    return 0L;
                }
                return LongMath.divide((long)(100L * dividend), (long)divisor, (RoundingMode)RoundingMode.HALF_UP);
            }
        }
    }
}

