/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.retranslate;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.retranslate.AOReTranslateKeysHelper;
import com.atlassian.jira.retranslate.JiraReTranslateKeysHelper;
import com.atlassian.jira.retranslate.KeyReplacementHelper;
import com.atlassian.jira.retranslate.ReTranslateKeysService;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.lang.Pair;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReTranslateKeysServiceImpl
implements ReTranslateKeysService {
    static final String SERVICE_ENABLED_PROPERTY_KEY = "com.atlassian.jira.retranslatekeys.enabled";
    static final String LOG_PREFIX = "[RETRANSLATE-KEYS] ";
    static final String EMPTY_TABLE_OR_ENTITY = "Empty table/entity name";
    static final String EMPTY_COLUMN_OR_FIELD = "Empty column/field name";
    static final String EMPTY_KEY = "Empty key";
    static final String NOT_ADMIN_MSG = "Authorization failed. Not logged in as admin.";
    static final String NOT_ENABLED_MSG = "ReTranslateKeysService is disabled. To enable, set system property com.atlassian.jira.retranslatekeys.enabled=true";
    private static final Logger log = LoggerFactory.getLogger(ReTranslateKeysServiceImpl.class);
    private final JiraReTranslateKeysHelper jiraHelper;
    private final AOReTranslateKeysHelper aoHelper;
    private final JiraAuthenticationContext authContext;
    private final GlobalPermissionManager globalPermissionManager;

    public ReTranslateKeysServiceImpl(ApplicationProperties appProps, I18nHelper.BeanFactory i18nFactory, OfBizDelegator ofBizDelegator, EventPublisher eventPublisher, QueryDslAccessor queryDslAccessor, JiraAuthenticationContext authContext, GlobalPermissionManager globalPermissionManager) {
        this(ofBizDelegator, eventPublisher, queryDslAccessor, authContext, globalPermissionManager, new KeyReplacementHelper(appProps, i18nFactory));
    }

    private ReTranslateKeysServiceImpl(OfBizDelegator ofBizDelegator, EventPublisher eventPublisher, QueryDslAccessor queryDslAccessor, JiraAuthenticationContext authContext, GlobalPermissionManager globalPermissionManager, KeyReplacementHelper keyReplacementHelper) {
        this(new JiraReTranslateKeysHelper(keyReplacementHelper, ofBizDelegator, eventPublisher), new AOReTranslateKeysHelper(keyReplacementHelper, queryDslAccessor), authContext, globalPermissionManager);
    }

    @VisibleForTesting
    ReTranslateKeysServiceImpl(JiraReTranslateKeysHelper jiraReTranslateKeysHelper, AOReTranslateKeysHelper aoReTranslateKeysHelper, JiraAuthenticationContext authContext, GlobalPermissionManager globalPermissionManager) {
        this.jiraHelper = jiraReTranslateKeysHelper;
        this.aoHelper = aoReTranslateKeysHelper;
        this.authContext = authContext;
        this.globalPermissionManager = globalPermissionManager;
    }

    @Override
    public ServiceOutcome<List<Pair<String, String>>> dryRunReTranslateAllKeys(String tableOrEntityName, String columnOrFieldName, String keyName) {
        return ReTranslateKeysServiceImpl.wrappingWithServiceOutcome(() -> {
            this.verifyFeatureEnabled();
            this.verifyNonEmptyInput(tableOrEntityName, columnOrFieldName, keyName);
            this.verifyAdminUser();
            return this.dryRunBasedOnTablePrefix(tableOrEntityName, columnOrFieldName, keyName);
        });
    }

    private List<Pair<String, String>> dryRunBasedOnTablePrefix(String tableOrEntityName, String columnOrFieldName, String keyName) {
        if (this.isAOTable(tableOrEntityName)) {
            String aoTableName = tableOrEntityName.toUpperCase();
            String aoColumnName = columnOrFieldName.toUpperCase();
            return this.aoHelper.dryRunReTranslateAllKeys(aoTableName, aoColumnName, keyName);
        }
        return this.jiraHelper.dryRunReTranslateAllKeys(tableOrEntityName, columnOrFieldName, keyName);
    }

    @Override
    public ServiceOutcome<List<Pair<String, String>>> reTranslateAllKeys(String tableOrEntityName, String columnOrFieldName, String keyName) {
        return ReTranslateKeysServiceImpl.wrappingWithServiceOutcome(() -> {
            this.verifyFeatureEnabled();
            this.verifyNonEmptyInput(tableOrEntityName, columnOrFieldName, keyName);
            this.verifyAdminUser();
            return this.reTranslateBasedOnTablePrefix(tableOrEntityName, columnOrFieldName, keyName);
        });
    }

    private List<Pair<String, String>> reTranslateBasedOnTablePrefix(String tableOrEntityName, String columnOrFieldName, String keyName) {
        if (this.isAOTable(tableOrEntityName)) {
            String aoTableName = tableOrEntityName.toUpperCase();
            String aoColumnName = columnOrFieldName.toUpperCase();
            return this.aoHelper.reTranslateAllKeys(aoTableName, aoColumnName, keyName);
        }
        return this.jiraHelper.reTranslateAllKeys(tableOrEntityName, columnOrFieldName, keyName);
    }

    private boolean isAOTable(String tableOrEntityName) {
        return tableOrEntityName.startsWith("AO_");
    }

    private static <T> ServiceOutcome<T> wrappingWithServiceOutcome(Supplier<T> action) {
        try {
            return ServiceOutcomeImpl.ok(action.get());
        }
        catch (ReTranslateException e) {
            return ServiceOutcomeImpl.from(e.errCollection);
        }
        catch (Throwable t) {
            log.error("[RETRANSLATE-KEYS] Unable to perform translation due to Server error: " + t.getMessage(), t);
            return ServiceOutcomeImpl.error("Unable to perform translation due to Server error. Please see the jira log for more details.");
        }
    }

    private void verifyNonEmptyInput(String tableOrEntityName, String columnOrFieldName, String keyName) {
        this.verifyNonEmpty(tableOrEntityName, EMPTY_TABLE_OR_ENTITY);
        this.verifyNonEmpty(columnOrFieldName, EMPTY_COLUMN_OR_FIELD);
        this.verifyNonEmpty(keyName, EMPTY_KEY);
    }

    private void verifyNonEmpty(String checkMe, String errorMsg) throws ReTranslateException {
        if (StringUtils.isEmpty((CharSequence)checkMe)) {
            log.warn("[RETRANSLATE-KEYS] Validation failed: " + errorMsg);
            throw new ReTranslateException(errorMsg, ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private void verifyAdminUser() {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authContext.getLoggedInUser())) {
            log.warn("[RETRANSLATE-KEYS] Authorization failed. Not logged in as admin.");
            throw new ReTranslateException(NOT_ADMIN_MSG, ErrorCollection.Reason.FORBIDDEN);
        }
    }

    private void verifyFeatureEnabled() {
        if (!JiraSystemProperties.getInstance().getBoolean(SERVICE_ENABLED_PROPERTY_KEY).booleanValue()) {
            log.warn("[RETRANSLATE-KEYS] ReTranslateKeysService is disabled. To enable, set system property com.atlassian.jira.retranslatekeys.enabled=true");
            throw new ReTranslateException(NOT_ENABLED_MSG, ErrorCollection.Reason.FORBIDDEN);
        }
    }

    static class ReTranslateException
    extends RuntimeException {
        final ErrorCollection errCollection;

        ReTranslateException(String message, ErrorCollection.Reason reason) {
            this.errCollection = new SimpleErrorCollection(message, reason);
        }

        public ReTranslateException(ErrorCollection errors) {
            this.errCollection = errors;
        }
    }
}

