/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.memory.MemoryCacheManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;

@ClusterSafe(value="This is a thread local cache and only exists for the life of the request.")
class PermissionsCache {
    private final Cache<Optional<String>, Collection<Project>> userProjectPermissions;
    private final Cache<Pair<Optional<String>, Long>, Boolean> userToProject;

    public PermissionsCache(int cacheSize) {
        MemoryCacheManager memoryCacheManager = new MemoryCacheManager();
        this.userProjectPermissions = memoryCacheManager.getCache("userProjectPermissions", null, new CacheSettingsBuilder().maxEntries(cacheSize).local().build());
        this.userToProject = memoryCacheManager.getCache("userToProject", null, new CacheSettingsBuilder().maxEntries(cacheSize).local().build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent ignored) {
        this.userProjectPermissions.removeAll();
        this.userToProject.removeAll();
    }

    Collection<Project> computeProjectsWithBrowsePermissionIfAbsent(ApplicationUser user, Supplier<Collection<Project>> getUserProjects) {
        Optional<String> key = this.toUserName(user);
        return (Collection)this.userProjectPermissions.get(key, getUserProjects::get);
    }

    boolean computePermissionIfAbsent(ApplicationUser user, Project project, Supplier<Boolean> hasPermission) {
        Pair key = Pair.of(this.toUserName(user), (Object)project.getId());
        return (Boolean)this.userToProject.get((Object)key, hasPermission::get);
    }

    private Optional<String> toUserName(@Nullable ApplicationUser user) {
        return Optional.ofNullable(user).map(ApplicationUser::getUsername);
    }
}

