/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.jwt;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtGenerateSecretException;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtSecretKeyService;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageAttachmentJwtSecretKeyServiceImpl
implements ImageAttachmentJwtSecretKeyService {
    private static final Logger logger = LoggerFactory.getLogger(ImageAttachmentJwtSecretKeyServiceImpl.class);
    @VisibleForTesting
    protected static final String LOCK_NAME = ImageAttachmentJwtSecretKeyServiceImpl.class.getName() + "-lock";
    @VisibleForTesting
    protected static final int REQUIRED_MIN_SECRET_LENGTH_BYTES = 32;
    private final SecureRandom secureRandom;
    private final Object cachedSecretLock = new Object();
    private byte[] cachedSecret = null;
    private final ApplicationProperties applicationProperties;
    private final ClusterLockService clusterLockService;

    public ImageAttachmentJwtSecretKeyServiceImpl(ApplicationProperties applicationProperties, ClusterLockService clusterLockService) {
        this.applicationProperties = applicationProperties;
        this.clusterLockService = clusterLockService;
        this.secureRandom = this.getSecureRandom();
    }

    private SecureRandom getSecureRandom() {
        SecureRandom strongerSecureRandom = null;
        try {
            strongerSecureRandom = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Stronger secure random is not available, falling back to default one", (Throwable)e);
        }
        if (strongerSecureRandom != null) {
            return strongerSecureRandom;
        }
        return new SecureRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generateOrGetSecretKey() throws ImageAttachmentJwtGenerateSecretException {
        Object object = this.cachedSecretLock;
        synchronized (object) {
            if (this.cachedSecret == null) {
                this.cachedSecret = this.doGenerateOrGetSecretKey();
            }
            return this.cachedSecret;
        }
    }

    private byte[] doGenerateOrGetSecretKey() throws ImageAttachmentJwtGenerateSecretException {
        String secretBase64Encoded = this.applicationProperties.getString("jira.security.image.attachment.jwt.tokens.secret");
        if (secretBase64Encoded != null && !secretBase64Encoded.isEmpty()) {
            return Base64.getDecoder().decode(secretBase64Encoded);
        }
        return this.generateNewSecretWithClusterLock();
    }

    private byte[] generateNewSecretWithClusterLock() throws ImageAttachmentJwtGenerateSecretException {
        ClusterLock clusterLock = this.clusterLockService.getLockForName(LOCK_NAME);
        try {
            if (clusterLock.tryLock(5L, TimeUnit.SECONDS)) {
                byte[] byArray = this.generateAndStoreNewSecretKey();
                return byArray;
            }
            try {
                throw new ImageAttachmentJwtGenerateSecretException("Could not get cluster lock");
            }
            catch (InterruptedException e) {
                throw new ImageAttachmentJwtGenerateSecretException("Interrupted while trying to get cluster lock");
            }
        }
        finally {
            clusterLock.unlock();
        }
    }

    private byte[] generateAndStoreNewSecretKey() {
        byte[] secret = new byte[32];
        this.secureRandom.nextBytes(secret);
        String secretBase64Encoded = Base64.getEncoder().encodeToString(secret);
        this.applicationProperties.setString("jira.security.image.attachment.jwt.tokens.secret", secretBase64Encoded);
        return secret;
    }
}

