/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.login;

import com.atlassian.core.util.Clock;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.dataimport.ImportStartedEvent;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginInfoImpl;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.security.login.BulkLoginStore;
import com.atlassian.jira.security.login.LoginStore;
import com.atlassian.jira.security.login.LoginStoreImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.LoginStoreStats;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedLoginStore
implements LoginStore {
    private static final Logger log = LoggerFactory.getLogger(DelayedLoginStore.class);
    static final String SYSTEM_PROPERTY_LEGACY_LOGIN_ATTRIBUTES_FLUSH_INTERVAL = "com.atlassian.jira.security.login.store.flush.seconds";
    public static final Duration FLUSH_INTERVAL = Duration.ofSeconds(JiraSystemProperties.getInstance().getLong("com.atlassian.jira.security.login.store.flush.seconds", Long.valueOf(30L)));
    public static final String DELAYED_STORE_IS_DISABLED_MSG = "delayed store is disabled, going straight to delegate LoginStore";
    private final ScheduledExecutorService scheduler;
    private final Runnable dbWriter = JiraThreadLocalUtils.wrap(this::flushDataToDB);
    static final String SYSTEM_PROPERTY_LEGACY_LOGIN_ATTRIBUTES_STORE = "com.atlassian.jira.security.login.store.legacy";
    private final boolean LEGACY_MODE_LOGIN_STORE = JiraSystemProperties.getInstance().getBoolean("com.atlassian.jira.security.login.store.legacy");
    private final Cache<ApplicationUser, LoginInfo> applicationUserToLastKnownLoginInfo = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(Duration.ofSeconds(60L)).build();
    private final ConcurrentHashMap<ApplicationUser, AtomicLong> userToRecordSuccessfulLoginAttempt = new ConcurrentHashMap();
    private final ConcurrentHashMap<ApplicationUser, AtomicLong> userToUpdateLastLoginTime = new ConcurrentHashMap();
    private final BulkLoginStore delegate;
    private final AtomicBoolean isScheduled = new AtomicBoolean(false);
    private final Clock clock;
    private final LoginStoreStats loginStoreStats;

    public DelayedLoginStore(Clock clock, ApplicationProperties applicationProperties, CrowdService crowdService, EventPublisher eventPublisher) {
        this(clock, new LoginStoreImpl(clock, applicationProperties, crowdService), eventPublisher);
    }

    public DelayedLoginStore(Clock clock, BulkLoginStore bulkLoginStore, EventPublisher eventPublisher) {
        this.clock = clock;
        this.delegate = bulkLoginStore;
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DelayedLoginStore:thread-%d").build());
        this.loginStoreStats = (LoginStoreStats)JiraStats.create(LoginStoreStats.class, LoginStoreStats::create, (boolean)false);
        eventPublisher.register((Object)this);
        this.loginStoreStats.settings(this.LEGACY_MODE_LOGIN_STORE, FLUSH_INTERVAL.getSeconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginInfo getLoginInfo(ApplicationUser user) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            if (this.isDelayedStoreDisabled()) {
                log.trace(DELAYED_STORE_IS_DISABLED_MSG);
                LoginInfo loginInfo = this.delegate.getLoginInfo(user);
                return loginInfo;
            }
            LoginInfo loginInfo = this.getLastKnownUpdatedWithCachedLoginInfo(user);
            return loginInfo;
        }
        finally {
            this.loginStoreStats.getLoginInfo(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public LoginInfo recordLoginAttempt(ApplicationUser user, boolean authenticated) {
        this.loginStoreStats.settings(this.LEGACY_MODE_LOGIN_STORE, FLUSH_INTERVAL.getSeconds());
        this.loginStoreStats.getApplicationUserToLastKnownLoginInfoSize(this.applicationUserToLastKnownLoginInfo.size());
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (this.isDelayedStoreDisabled()) {
            log.trace(DELAYED_STORE_IS_DISABLED_MSG);
            Stopwatch stopwatchForDelegate = Stopwatch.createStarted();
            LoginInfo loginInfo = this.delegate.recordLoginAttempt(user, authenticated);
            if (authenticated) {
                this.loginStoreStats.delegateRecordLoginAttemptTrue(stopwatchForDelegate.elapsed(TimeUnit.MILLISECONDS));
            } else {
                this.loginStoreStats.delegateRecordLoginAttemptFalse(stopwatchForDelegate.elapsed(TimeUnit.MILLISECONDS));
            }
            return loginInfo;
        }
        this.validateRunning();
        if (authenticated) {
            long counter = this.updateCountBuffer(user, this.userToRecordSuccessfulLoginAttempt);
            if (counter == 0L) {
                Stopwatch stopwatchForDelegate = Stopwatch.createStarted();
                this.delegate.recordLoginAttempt(user, true);
                this.loginStoreStats.delegateRecordLoginAttemptTrue(stopwatchForDelegate.elapsed(TimeUnit.MILLISECONDS));
                this.invalidateLastKnownLoginInfoCache(user);
            }
            this.loginStoreStats.recordLoginAttemptTrue(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return this.getLoginInfo(user);
        }
        this.flushUserAttempts(user);
        Stopwatch stopwatchForDelegate = Stopwatch.createStarted();
        LoginInfo result = this.delegate.recordLoginAttempt(user, false);
        this.loginStoreStats.delegateRecordLoginAttemptFalse(stopwatchForDelegate.elapsed(TimeUnit.MILLISECONDS));
        this.invalidateLastKnownLoginInfoCache(user);
        this.loginStoreStats.recordLoginAttemptFalse(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return result;
    }

    private long updateCountBuffer(ApplicationUser user, ConcurrentMap<ApplicationUser, AtomicLong> userToNumberOfBufferedOps) {
        AtomicBoolean isBufferEmpty = new AtomicBoolean(false);
        AtomicLong counter = userToNumberOfBufferedOps.compute(user, (u, v) -> {
            if (v == null) {
                isBufferEmpty.set(true);
                return new AtomicLong(0L);
            }
            v.incrementAndGet();
            return v;
        });
        return isBufferEmpty.get() ? 0L : counter.get();
    }

    private LoginInfo getLastKnownUpdatedWithCachedLoginInfo(ApplicationUser user) {
        LoginInfo lastKnownLoginInfo = this.getLastKnownLoginInfo(user);
        long numberOfUnflushedLoginAttempts = this.getNumberOfUnflushedLoginAttempts(user);
        if (numberOfUnflushedLoginAttempts == 0L) {
            return lastKnownLoginInfo;
        }
        return LoginInfoImpl.builder(lastKnownLoginInfo).setPreviousLoginTime(lastKnownLoginInfo.getLastLoginTime()).setLastLoginTime(this.now()).setLoginCount(lastKnownLoginInfo.getLoginCount() == null ? 0L : lastKnownLoginInfo.getLoginCount() + numberOfUnflushedLoginAttempts).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginInfo updateLastLoginTime(ApplicationUser user) {
        this.loginStoreStats.getApplicationUserToLastKnownLoginInfoSize(this.applicationUserToLastKnownLoginInfo.size());
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            if (this.isDelayedStoreDisabled()) {
                log.trace(DELAYED_STORE_IS_DISABLED_MSG);
                Stopwatch stopwatchForDelegate = Stopwatch.createStarted();
                LoginInfo loginInfo = this.delegate.updateLastLoginTime(user);
                this.loginStoreStats.delegateUpdateLastLoginTime(stopwatchForDelegate.elapsed(TimeUnit.MILLISECONDS));
                LoginInfo loginInfo2 = loginInfo;
                return loginInfo2;
            }
            this.validateRunning();
            long counter = this.updateCountBuffer(user, this.userToUpdateLastLoginTime);
            if (counter == 0L) {
                Stopwatch stopwatchForDelegate = Stopwatch.createStarted();
                this.delegate.updateLastLoginTime(user);
                this.loginStoreStats.delegateUpdateLastLoginTime(stopwatchForDelegate.elapsed(TimeUnit.MILLISECONDS));
                this.invalidateLastKnownLoginInfoCache(user);
            }
            LoginInfo loginInfo = this.getLastKnownUpdatedWithCachedLoginInfo(user);
            return loginInfo;
        }
        finally {
            this.loginStoreStats.updateLastLoginTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public long getMaxAuthenticationAttemptsAllowed() {
        return this.delegate.getMaxAuthenticationAttemptsAllowed();
    }

    @Override
    public void resetFailedLoginCount(ApplicationUser user) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (this.isDelayedStoreEnabled()) {
            this.applicationUserToLastKnownLoginInfo.invalidate((Object)user);
        }
        Stopwatch stopwatchForDelegate = Stopwatch.createStarted();
        this.delegate.resetFailedLoginCount(user);
        this.loginStoreStats.delegateResetFailedLoginCount(stopwatchForDelegate.elapsed(TimeUnit.MILLISECONDS));
        this.loginStoreStats.resetFailedLoginCount(stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private LoginInfo getLastKnownLoginInfo(ApplicationUser user) {
        try {
            return (LoginInfo)this.applicationUserToLastKnownLoginInfo.get((Object)user, () -> {
                this.loginStoreStats.lastKnownLoginInfoCacheCall();
                return this.delegate.getLoginInfo(user);
            });
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    private void invalidateLastKnownLoginInfoCache(ApplicationUser user) {
        this.applicationUserToLastKnownLoginInfo.invalidate((Object)user);
        this.loginStoreStats.invalidateLastKnownLoginInfoCache();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.userToUpdateLastLoginTime.clear();
        this.userToRecordSuccessfulLoginAttempt.clear();
        this.applicationUserToLastKnownLoginInfo.invalidateAll();
        this.loginStoreStats.onClearCache();
    }

    @EventListener
    public void onPluginFrameworkStartedEvent(PluginFrameworkStartedEvent event) {
        if (this.isDelayedStoreEnabled()) {
            this.scheduler.scheduleAtFixedRate(this.dbWriter, FLUSH_INTERVAL.getSeconds(), FLUSH_INTERVAL.getSeconds(), TimeUnit.SECONDS);
            this.isScheduled.set(true);
        }
    }

    @EventListener
    public void onPluginFrameworkShutdownEvent(PluginFrameworkShutdownEvent event) {
        if (this.isDelayedStoreEnabled()) {
            this.scheduler.shutdown();
            this.isScheduled.set(false);
            this.flushDataToDB();
        }
    }

    @EventListener
    @VisibleForTesting
    public void onImportStartedEvent(ImportStartedEvent event) {
        if (this.isDelayedStoreEnabled()) {
            this.flushDataToDB();
        }
    }

    private boolean isDelayedStoreDisabled() {
        return this.LEGACY_MODE_LOGIN_STORE;
    }

    private boolean isDelayedStoreEnabled() {
        return !this.isDelayedStoreDisabled();
    }

    private void validateRunning() {
        if (this.isDelayedStoreEnabled() && (this.scheduler.isShutdown() || !this.isScheduled.get())) {
            this.loginStoreStats.validateRunningFailed();
            log.error("Login store is not enabled, and cannot be used at this stage");
            throw new IllegalStateException("Login Store is not enabled and cannot be used at this stage");
        }
    }

    synchronized void flushDataToDB() {
        log.debug("flushing buffered login info - start");
        Stopwatch stopwatch = Stopwatch.createStarted();
        long usersCount = 0L;
        for (ApplicationUser applicationUser : this.userToRecordSuccessfulLoginAttempt.keySet()) {
            try {
                this.flushRecordedSuccessfulLoginAttempts(applicationUser);
                ++usersCount;
            }
            catch (Throwable t) {
                this.printErrorMessage(applicationUser, t);
                this.loginStoreStats.flushRecordedSuccessfulLoginAttemptsUnsuccessful();
            }
        }
        for (ApplicationUser applicationUser : this.userToUpdateLastLoginTime.keySet()) {
            try {
                this.flushLastLoginTimes(applicationUser);
                ++usersCount;
            }
            catch (Throwable t) {
                this.printErrorMessage(applicationUser, t);
                this.loginStoreStats.flushLastLoginTimesUnsuccessful();
            }
            this.loginStoreStats.usersFlushedToDB(usersCount);
        }
        this.loginStoreStats.flushDataToDB(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        log.debug("flushing buffered login info - complete");
    }

    private void printErrorMessage(ApplicationUser applicationUser, Throwable t) {
        log.warn("Could not save buffered successful login count for user {} because of an exception : [{}]. Some information about the number of successful logins within the last {} seconds might have got lost. Enable DEBUG logging to see stack trace", new Object[]{applicationUser, t.getMessage(), FLUSH_INTERVAL});
        log.debug("Could not save buffered successful login count for user {} because of an exception.", (Object)applicationUser, (Object)t);
    }

    private void flushUserAttempts(ApplicationUser user) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.flushRecordedSuccessfulLoginAttempts(user);
        this.flushLastLoginTimes(user);
        this.loginStoreStats.unscheduledFlushUserAttempts(stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private void flushRecordedSuccessfulLoginAttempts(ApplicationUser applicationUser) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Optional.ofNullable(this.userToRecordSuccessfulLoginAttempt.remove(applicationUser)).map(AtomicLong::get).filter(counter -> counter > 0L).ifPresent(counter -> {
            this.delegate.recordSuccessfulLoginAttempt(applicationUser, (long)counter);
            this.invalidateLastKnownLoginInfoCache(applicationUser);
        });
        this.loginStoreStats.flushRecordedSuccessfulLoginAttempts(stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private void flushLastLoginTimes(ApplicationUser applicationUser) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Optional.ofNullable(this.userToUpdateLastLoginTime.remove(applicationUser)).map(AtomicLong::get).filter(counter -> counter > 0L).ifPresent(counter -> {
            this.delegate.updateLastLoginTime(applicationUser, (long)counter);
            this.invalidateLastKnownLoginInfoCache(applicationUser);
        });
        this.loginStoreStats.flushLastLoginTimes(stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private long getNumberOfUnflushedLoginAttempts(ApplicationUser applicationUser) {
        return Optional.ofNullable(this.userToRecordSuccessfulLoginAttempt.get(applicationUser)).map(AtomicLong::get).orElse(0L) + Optional.ofNullable(this.userToUpdateLastLoginTime.get(applicationUser)).map(AtomicLong::get).orElse(0L);
    }

    private long now() {
        return this.clock.getCurrentDate().getTime();
    }
}

