/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public interface ProjectRoleAndActorStore {
    public ProjectRole addProjectRole(ProjectRole var1);

    public void updateProjectRole(ProjectRole var1);

    public Collection<ProjectRole> getAllProjectRoles();

    public ProjectRole getProjectRole(Long var1);

    public ProjectRole getProjectRoleByName(String var1);

    public void deleteProjectRole(ProjectRole var1);

    public ProjectRoleActors getProjectRoleActors(@Nonnull Long var1, Long var2);

    public void updateProjectRoleActors(ProjectRoleActors var1);

    public void updateDefaultRoleActors(DefaultRoleActors var1);

    public DefaultRoleActors getDefaultRoleActors(@Nonnull Long var1);

    public void applyDefaultsRolesToProject(Project var1);

    public void removeAllRoleActorsByKeyAndType(String var1, String var2);

    public void removeAllRoleActorsByProject(Project var1);

    public Collection<Long> getProjectIdsContainingRoleActorByKeyAndType(String var1, String var2);

    public List<Long> roleActorOfTypeExistsForProjects(List<Long> var1, ProjectRole var2, String var3, String var4);

    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(List<Long> var1, ProjectRole var2, String var3, String var4);

    public boolean isGroupUsed(@Nonnull String var1);

    public ProjectRoleManager.ProjectIdToProjectRoleIdsMap getProjectIdToRoleIds(@Nonnull String var1, @Nonnull String var2);

    public List<RoleTypeMapping> getRoleActorsParametersAndTypeByProjectId(@Nonnull Long var1);

    public List<RoleTypeMapping> getRoleActorsParametersAndTypeByProjectRoleId(@Nonnull Long var1);

    @Immutable
    public static class RoleTypeMapping
    implements Serializable {
        private static final long serialVersionUID = -7979207499856224148L;
        private final String roleTypeParameter;
        private final String roleType;

        private RoleTypeMapping(@Nonnull String roleTypeParameter, @Nonnull String roleType) {
            this.roleTypeParameter = Objects.requireNonNull(roleTypeParameter);
            this.roleType = Objects.requireNonNull(roleType);
        }

        static RoleTypeMapping of(@Nonnull String roleTypeParameter, @Nonnull String roleType) {
            return new RoleTypeMapping(roleTypeParameter, roleType);
        }

        @Nonnull
        public String getRoleTypeParameter() {
            return this.roleTypeParameter;
        }

        @Nonnull
        public String getRoleType() {
            return this.roleType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RoleTypeMapping)) {
                return false;
            }
            RoleTypeMapping that = (RoleTypeMapping)o;
            return Objects.equals(this.roleTypeParameter, that.roleTypeParameter) && Objects.equals(this.roleType, that.roleType);
        }

        public int hashCode() {
            return Objects.hash(this.roleTypeParameter, this.roleType);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("roleTypeParameter", (Object)this.roleTypeParameter).append("roleType", (Object)this.roleType).toString();
        }
    }
}

