/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.bc.user.search.UserSearchUtilities;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.util.BytesRef;

public interface SecurityType
extends SchemeType {
    public boolean isTopLevelProjectPermission();

    public boolean isTopLevelIssueSecurityPermission();

    public Set<BytesRef> getPermissionFieldContents(ApplicationUser var1, Project var2, String var3);

    public Set<BytesRef> getPermissionFieldContents(ApplicationUser var1, Project var2, IssueSecurityLevel var3, String var4);

    public String getArgumentDisplay(String var1);

    @Deprecated
    public Set<ApplicationUser> getUsers(@Nonnull PermissionContext var1, @Nullable String var2);

    @Nonnull
    default public Set<ApplicationUser> getUsers(@Nonnull PermissionContext permissionContext, @Nullable String argument, @Nonnull String userSearchName, int limit) {
        if (limit == 0) {
            return new HashSet<ApplicationUser>();
        }
        return this.getUsers(permissionContext, argument).stream().sorted(Comparator.comparing(ApplicationUser::getDisplayName, Comparator.comparing(IdentifierUtils::toLowerCase)).thenComparing(ApplicationUser::getUsername, Comparator.comparing(IdentifierUtils::toLowerCase))).filter(user -> UserSearchUtilities.userSearchMatchUser(user, userSearchName)).limit(limit).collect(Collectors.toSet());
    }
}

