/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.xsrf;

import com.atlassian.http.url.SameOrigin;
import com.atlassian.jira.component.ComponentAccessor;
import com.google.common.collect.ImmutableSet;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class OriginChecker {
    private static final ImmutableSet<String> BROWSER_EXTENSION_ORIGINS = ImmutableSet.of((Object)"chrome-extension", (Object)"safari-extension");

    private OriginChecker() {
    }

    public static boolean isOriginAllowed(HttpServletRequest request) {
        String requestUrl;
        String origin = request.getHeader("Origin");
        String referrer = OriginChecker.getSanitisedReferrer(request);
        return OriginChecker.isSameOrigin(referrer, requestUrl = request.getRequestURL().toString()) || OriginChecker.isSameOrigin(origin, requestUrl) || OriginChecker.isOriginABrowserExtension(origin);
    }

    public static boolean isOriginABrowserExtension(String origin) {
        if (StringUtils.isEmpty((CharSequence)origin)) {
            return false;
        }
        try {
            URI originUri = new URI(origin);
            return OriginChecker.getBrowserExtensionOrigins().contains((Object)originUri.getScheme()) && !originUri.isOpaque();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private static String getSanitisedReferrer(HttpServletRequest request) {
        return StringUtils.substringBefore((String)request.getHeader("Referer"), (String)"?");
    }

    private static boolean isSameOrigin(String uri, String origin) {
        try {
            return StringUtils.isNotEmpty((CharSequence)uri) && SameOrigin.isSameOrigin((URI)new URI(uri), (URI)new URI(origin));
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            return false;
        }
    }

    private static ImmutableSet<String> getBrowserExtensionOrigins() {
        String extensionList = ComponentAccessor.getApplicationProperties().getDefaultBackedString("com.atlassian.jira.xsrf.allowed.browswer.extension.origins");
        if (extensionList == null) {
            return BROWSER_EXTENSION_ORIGINS;
        }
        if (extensionList.isEmpty()) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Object[])extensionList.split("\n"));
    }
}

