/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.xsrf;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.license.JiraServerIdProvider;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.WebworkRequestPredicate;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.security.xsrf.XsrfTokenStore;
import com.atlassian.jira.security.xsrf.XsrfTokenStrategy;
import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import com.atlassian.jira.web.ExecutingHttpRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class SimpleXsrfTokenGenerator
implements XsrfTokenGenerator {
    private final FeatureManager featureManager;
    private final UserAgentUtil userAgentUtil;
    private final XsrfTokenStrategy cookieStrategy;
    private final XsrfTokenStrategy sessionStrategy;
    private WebworkRequestPredicate webworkReqPredicate;

    public SimpleXsrfTokenGenerator(JiraAuthenticationContext authenticationContext, JiraServerIdProvider jiraServerIdProvider, FeatureManager featureManager) {
        this.featureManager = featureManager;
        this.cookieStrategy = XsrfTokenStrategy.newInstance(XsrfTokenStrategy.Type.COOKIE, authenticationContext, jiraServerIdProvider);
        this.sessionStrategy = XsrfTokenStrategy.newInstance(XsrfTokenStrategy.Type.SESSION, authenticationContext, jiraServerIdProvider);
        this.userAgentUtil = new UserAgentUtilImpl();
    }

    public String generateToken(HttpServletRequest httpServletRequest) {
        return this.generateTokenImpl(httpServletRequest, true);
    }

    public String generateToken(HttpServletRequest httpServletRequest, boolean create) {
        return this.generateTokenImpl(httpServletRequest, create);
    }

    public String generateToken() {
        return this.generateTokenImpl(null, true);
    }

    public String generateToken(boolean create) {
        return this.generateTokenImpl(null, create);
    }

    public String getXsrfTokenName() {
        return "atlassian.xsrf.token";
    }

    public boolean validateToken(HttpServletRequest request, String token) {
        return this.resolveTokenStrategy(request).isValidToken(request, token);
    }

    public boolean generatedByAuthenticatedUser(String token) {
        return XsrfTokenStrategy.isGeneratedByAuthenticatedUser(token);
    }

    public String getToken(HttpServletRequest request) {
        return XsrfTokenStore.cookie(request).get();
    }

    UserAgentUtil getUserAgentUtil() {
        return this.userAgentUtil;
    }

    private String generateTokenImpl(HttpServletRequest request, boolean create) {
        HttpServletRequest safeRequest = this.safeAccess(request);
        if (null == safeRequest) {
            return null;
        }
        String pendingToken = XsrfTokenStrategy.getPendingToken(safeRequest);
        if (StringUtils.isNotBlank((CharSequence)pendingToken)) {
            return pendingToken;
        }
        return this.resolveTokenStrategy(safeRequest).getToken(safeRequest, create);
    }

    private XsrfTokenStrategy resolveTokenStrategy(HttpServletRequest request) {
        return this.canUseSessionTokenStrategy(request) ? this.sessionStrategy : this.cookieStrategy;
    }

    private boolean canUseSessionTokenStrategy(HttpServletRequest request) {
        return this.isSessionTokenStrategyEnabled() && (this.hasSession(request) || this.isKnownUserAgent(request) && this.isWebWorkCall(request));
    }

    private boolean isSessionTokenStrategyEnabled() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.SECURITY_XSRF_SESSION_TOKEN);
    }

    private boolean isWebWorkCall(HttpServletRequest request) {
        if (this.webworkReqPredicate == null) {
            this.webworkReqPredicate = WebworkRequestPredicate.create(request.getServletContext());
        }
        return this.webworkReqPredicate.test(request);
    }

    private boolean isKnownUserAgent(HttpServletRequest request) {
        String userAgent = request.getHeader("USER-AGENT");
        UserAgentUtil.BrowserFamily browserFamily = this.getUserAgentUtil().getUserAgentInfo(userAgent).getBrowser().getBrowserFamily();
        return !UserAgentUtil.BrowserFamily.UKNOWN.equals((Object)browserFamily);
    }

    private boolean hasSession(HttpServletRequest request) {
        return request.getSession(false) != null;
    }

    private HttpServletRequest safeAccess(HttpServletRequest httpServletRequest) {
        return httpServletRequest != null ? httpServletRequest : ExecutingHttpRequest.get();
    }
}

