/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servermetrics;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.instrumentation.operations.OpSnapshot;
import com.atlassian.instrumentation.operations.OpTimerFactory;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.servermetrics.MultiThreadedRequestKeyResolver;
import com.atlassian.jira.servermetrics.MultiThreadedRequestMetricsCollector;
import com.atlassian.jira.servermetrics.RequestActivities;
import com.atlassian.jira.servermetrics.RequestCheckpoints;
import com.atlassian.jira.servermetrics.TimingInformation;
import com.atlassian.jira.servermetrics.TimingInformationToEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.HttpServletRequest;

@ParametersAreNonnullByDefault
@ThreadSafe
public class RequestMetricsDispatcher {
    private static final String SERVER_RENDER_END_CHECKPOINT = RequestCheckpoints.serverRenderEnd.name();
    private final Set<String> DISABLED_SERVLET_PREFIXES = ImmutableSet.of((Object)"/s/", (Object)"/rest/", (Object)"/images/", (Object)"/download/");
    private final MultiThreadedRequestMetricsCollector requestPartitioning;
    private final EventPublisher eventPublisher;
    private final TimingInformationToEvent timingInformationToEvent;
    private final MultiThreadedRequestKeyResolver requestKeyResolver;
    private final OpTimerFactory instrumentRegistry;
    private static final Map<String, String> RECORDED_INSTRUMENTS_2_ACTIVITY_NAMES = ImmutableMap.builder().put((Object)InstrumentationName.DB_READS.getInstrumentName(), (Object)RequestActivities.dbRead.name()).put((Object)InstrumentationName.DB_CONNECTIONS.getInstrumentName(), (Object)RequestActivities.dbConnected.name()).build();

    public RequestMetricsDispatcher(MultiThreadedRequestMetricsCollector requestPartitioning, EventPublisher eventPublisher, TimingInformationToEvent timingInformationToEvent, MultiThreadedRequestKeyResolver requestKeyResolver, OpTimerFactory instrumentRegistry) {
        this.requestPartitioning = requestPartitioning;
        this.eventPublisher = eventPublisher;
        this.timingInformationToEvent = timingInformationToEvent;
        this.requestKeyResolver = requestKeyResolver;
        this.instrumentRegistry = instrumentRegistry;
    }

    @Nonnull
    public CollectorHandle startCollection(HttpServletRequest httpServletRequest) {
        String requestPath = RequestMetricsDispatcher.getRequestPath(httpServletRequest);
        if (this.isRequestPathAllowedForCollection(requestPath)) {
            this.requestKeyResolver.requestStarted(httpServletRequest);
            this.requestPartitioning.startCollectionInCurrentThread();
        }
        return new CollectorHandle(httpServletRequest);
    }

    public void stopCollection(HttpServletRequest httpServletRequest) {
        String requestPath = RequestMetricsDispatcher.getRequestPath(httpServletRequest);
        if (this.isRequestPathAllowedForCollection(requestPath)) {
            this.requestPartitioning.checkpointReachedOverride(SERVER_RENDER_END_CHECKPOINT);
            this.fillSystemMetrics(this.requestPartitioning);
            Optional<TimingInformation> requestTimingStats = this.requestPartitioning.finishCollectionInCurrentThread();
            Optional<String> requestKey = this.requestKeyResolver.requestFinished(httpServletRequest);
            requestTimingStats.map(timingInformation -> this.timingInformationToEvent.createStatEvent((TimingInformation)timingInformation, httpServletRequest, requestKey)).ifPresent(arg_0 -> ((EventPublisher)this.eventPublisher).publish(arg_0));
        }
    }

    static String getRequestPath(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getServletPath() + (httpServletRequest.getPathInfo() != null ? "/" + httpServletRequest.getPathInfo() : "");
    }

    private boolean isRequestPathAllowedForCollection(String servletPath) {
        return !this.DISABLED_SERVLET_PREFIXES.stream().anyMatch(servletPath::startsWith);
    }

    private void fillSystemMetrics(MultiThreadedRequestMetricsCollector collector) {
        List<OpSnapshot> opSnapshots = Instrumentation.snapshotThreadLocalOperations(this.instrumentRegistry);
        opSnapshots.stream().filter(opSnapshot -> RECORDED_INSTRUMENTS_2_ACTIVITY_NAMES.containsKey(opSnapshot.getName())).limit(RECORDED_INSTRUMENTS_2_ACTIVITY_NAMES.size()).forEach(opSnapshot -> collector.setTimeSpentInActivity(RECORDED_INSTRUMENTS_2_ACTIVITY_NAMES.get(opSnapshot.getName()), Duration.ofNanos(opSnapshot.getElapsedTotalTime(TimeUnit.NANOSECONDS))));
    }

    public class CollectorHandle
    implements AutoCloseable {
        private final HttpServletRequest httpServletRequest;

        CollectorHandle(HttpServletRequest httpServletRequest) {
            this.httpServletRequest = httpServletRequest;
        }

        @Override
        public void close() {
            RequestMetricsDispatcher.this.stopCollection(this.httpServletRequest);
        }
    }
}

