/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.sharing.SharedEntityColumnDefinition;
import com.atlassian.jira.sharing.index.QueryFactory;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Preconditions;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class IsSharedQueryFactory
implements QueryFactory {
    private final FeatureManager featureManager;
    private final GlobalPermissionManager globalPermissionManager;

    public IsSharedQueryFactory(FeatureManager featureManager, GlobalPermissionManager globalPermissionManager) {
        this.featureManager = featureManager;
        this.globalPermissionManager = globalPermissionManager;
    }

    @Override
    public Query create(SharedEntitySearchParameters searchParameters, ApplicationUser user) {
        Preconditions.checkArgument((boolean)this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user), (String)"%s can only be used by admin users", (Object)IsSharedQueryFactory.class.getName());
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS)) {
            return new MatchAllDocsQuery();
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        query.add((Query)new TermQuery(new Term(SharedEntityColumnDefinition.IS_SHARED.getName(), "true")), BooleanClause.Occur.MUST);
        return query.build();
    }

    @Override
    public Query create(SharedEntitySearchParameters searchParameters) {
        throw new UnsupportedOperationException();
    }
}

