/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.AbstractShareTypeValidator;
import com.atlassian.jira.sharing.type.GlobalShareType;
import com.atlassian.jira.sharing.type.ShareTypeValidator;
import com.atlassian.jira.util.dbc.Assertions;

public class GlobalShareTypeValidator
extends AbstractShareTypeValidator
implements ShareTypeValidator {
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;

    public GlobalShareTypeValidator(PermissionManager permissionManager, ApplicationProperties applicationProperties) {
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
    }

    public boolean checkSharePermission(JiraServiceContext ctx, SharePermission permission) {
        boolean hasPermission;
        Assertions.notNull((String)"ctx", (Object)ctx);
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.equals((String)GlobalShareType.TYPE.toString(), (Object)GlobalShareType.TYPE, (Object)permission.getType());
        boolean globalSharingAllowed = this.applicationProperties.getOption("jira.option.globalsharing");
        if (!globalSharingAllowed) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.sharing.exception.no.share.permission.public"));
        }
        if (!(hasPermission = this.permissionManager.hasPermission(22, ctx.getLoggedInApplicationUser()))) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.sharing.exception.no.share.permission"));
        }
        if (!this.validateUsageContext(permission)) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.sharing.exception.invalid.usage.context.global"));
        }
        return !ctx.getErrorCollection().hasAnyErrors();
    }

    public boolean checkSearchParameter(JiraServiceContext ctx, ShareTypeSearchParameter searchParameter) {
        Assertions.notNull((String)"ctx", (Object)ctx);
        Assertions.notNull((String)"searchParameter", (Object)searchParameter);
        Assertions.equals((String)GlobalShareType.TYPE.toString(), (Object)GlobalShareType.TYPE, (Object)searchParameter.getType());
        return true;
    }
}

