/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.webwork.WebworkConfigurator;
import com.atlassian.jira.health.HealthChecks;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapContainerLauncher {
    private static final Logger log = LoggerFactory.getLogger(BootstrapContainerLauncher.class);

    public void start() {
        try {
            ComponentManager.getInstance().createBootstrapContainer();
            HealthChecks.runHealthChecks(LifecyclePhase.PRE_DATABASE_LAUNCH);
            if (!JohnsonProvider.isStartupOk()) {
                this.extendBootstrapContainerToRenderJohnsonPage();
                return;
            }
            DatabaseConfigurationManager dbcm = (DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class);
            if (!dbcm.isDatabaseSetup()) {
                this.bootstrapJIRAWhenDBIsNotSetup(dbcm);
                return;
            }
            this.extendBootstrapContainerToRenderJohnsonPage();
            HealthChecks.runHealthChecks(LifecyclePhase.DATABASE_CONFIGURED);
        }
        catch (Exception ex) {
            log.error("A fatal error occurred during bootstrapping. JIRA has been locked.", (Throwable)ex);
            HealthChecks.raiseFatalStartupProblem();
        }
    }

    private void extendBootstrapContainerToRenderJohnsonPage() {
        ComponentManager.getInstance().extendBootstrapContainerForDisplayingErrors();
    }

    private void bootstrapJIRAWhenDBIsNotSetup(DatabaseConfigurationManager dbcm) {
        block2: {
            ComponentManager.getInstance().extendBootstrapContainerForSetup();
            try {
                dbcm.getDatabaseConfiguration();
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof FileNotFoundException)) break block2;
                dbcm.createDbConfigFromEntityDefinition();
            }
        }
        ComponentManager.getInstance().earlyStartPluginSystem();
        WebworkConfigurator.setupConfiguration();
    }
}

