/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.beehive.core.ClusterLockStatus;
import com.atlassian.beehive.db.spi.ClusterLockDao;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterServicesManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.heartbeat.ClusterNodeHeartBeatDao;
import com.atlassian.jira.cluster.monitoring.ClusterMonitoringBeansRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ObjectArrays;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringLauncher {
    private static final String INDEX_START_TAG = "[INDEX_START] ";
    @VisibleForTesting
    static final String INDEX_START_CLUSTER_LOCK = "com.atlassian.jira.start.index.lock";
    private static final String CURRENT_NODE_TAG = "Current node: {}. ";
    private static final Logger log = LoggerFactory.getLogger(ClusteringLauncher.class);
    public static final long LOCK_POLL_INTERVAL_SECONDS = 5L;
    private final ClusterMonitoringBeansRegistrar clusterMonitoringBeansRegistrar;
    private final long lockRetryMillis;
    private boolean clusterMonitoringStarted;
    private final Supplier<ClusterLockService> clusterLockServiceRef;
    private final Supplier<ClusterManager> clusterManagerRef;
    private final Supplier<ClusterLockDao> clusterLockDaoRef;
    private final Supplier<ClusterServicesManager> clusterServicesManagerRef;
    private final Supplier<FeatureManager> featureManagerRef;
    private final Supplier<ClusterNodeHeartBeatDao> clusterNodeHeartBeatDaoRef;

    ClusteringLauncher() {
        this(new ClusterMonitoringBeansRegistrar(), (Supplier<ClusterLockService>)ComponentAccessor.getComponentReference(ClusterLockService.class), (Supplier<ClusterManager>)ComponentAccessor.getComponentReference(ClusterManager.class), (Supplier<ClusterLockDao>)ComponentAccessor.getComponentReference(ClusterLockDao.class), (Supplier<ClusterServicesManager>)ComponentAccessor.getComponentReference(ClusterServicesManager.class), (Supplier<FeatureManager>)ComponentAccessor.getComponentReference(FeatureManager.class), (Supplier<ClusterNodeHeartBeatDao>)ComponentAccessor.getComponentReference(ClusterNodeHeartBeatDao.class), TimeUnit.SECONDS.toMillis(5L));
    }

    @VisibleForTesting
    public ClusteringLauncher(ClusterMonitoringBeansRegistrar clusterMonitoringBeansRegistrar, Supplier<ClusterLockService> clusterLockServiceRef, Supplier<ClusterManager> clusterManagerRef, Supplier<ClusterLockDao> clusterLockDaoRef, Supplier<ClusterServicesManager> clusterServicesManagerRef, Supplier<FeatureManager> featureManagerRef, Supplier<ClusterNodeHeartBeatDao> clusterNodeHeartBeatDaoRef, long lockRetryMillis) {
        this.clusterMonitoringBeansRegistrar = clusterMonitoringBeansRegistrar;
        this.clusterLockServiceRef = clusterLockServiceRef;
        this.clusterManagerRef = clusterManagerRef;
        this.clusterLockDaoRef = clusterLockDaoRef;
        this.clusterServicesManagerRef = clusterServicesManagerRef;
        this.featureManagerRef = featureManagerRef;
        this.clusterNodeHeartBeatDaoRef = clusterNodeHeartBeatDaoRef;
        this.lockRetryMillis = lockRetryMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clusterSynchronizedCheckIndex() {
        ClusterManager clusterManager = this.clusterManagerRef.get();
        ClusterLockService clusterLockService = this.clusterLockServiceRef.get();
        ClusterLockDao clusterLockDao = this.clusterLockDaoRef.get();
        ClusterLock clusterStartLock = clusterLockService.getLockForName(INDEX_START_CLUSTER_LOCK);
        boolean indexCheckFinished = false;
        do {
            if (clusterStartLock.tryLock()) {
                try {
                    this.logWithPrefix("Acquired lock {} to check the index availability. Other nodes will wait with starting until this one is done.", INDEX_START_CLUSTER_LOCK);
                    this.logOnlineNodes();
                    clusterManager.checkIndexOnStart();
                    clusterStartLock.unlock();
                }
                catch (Throwable throwable) {
                    clusterStartLock.unlock();
                    this.logWithPrefix("Released lock {}", INDEX_START_CLUSTER_LOCK);
                    this.logOnlineNodes();
                    indexCheckFinished = true;
                    throw throwable;
                }
                this.logWithPrefix("Released lock {}", INDEX_START_CLUSTER_LOCK);
                this.logOnlineNodes();
                indexCheckFinished = true;
                continue;
            }
            ClusterLockStatus lockStatus = Optional.ofNullable(clusterLockDao.getClusterLockStatusByName(INDEX_START_CLUSTER_LOCK)).orElse(new ClusterLockStatus(INDEX_START_CLUSTER_LOCK, "unknown", 0L));
            this.logWithPrefix("Waiting for lock {} to check index availability. The lock is currently held by node {}. Last lock renewal happened at {}", INDEX_START_CLUSTER_LOCK, lockStatus.getLockedByNode(), LocalDateTime.ofInstant(Instant.ofEpochMilli(lockStatus.getUpdateTime()), ZoneId.systemDefault()));
            this.logOnlineNodes();
            try {
                Thread.sleep(this.lockRetryMillis);
            }
            catch (InterruptedException exception) {
                throw new RuntimeException(exception);
            }
        } while (!indexCheckFinished);
    }

    public void start() {
        ClusterManager clusterManager = this.clusterManagerRef.get();
        if (clusterManager.isClustered()) {
            this.clusterSynchronizedCheckIndex();
            FeatureManager featureManager = this.featureManagerRef.get();
            if (featureManager.isEnabled("jira.zdu.jmx-monitoring")) {
                this.clusterMonitoringBeansRegistrar.registerClusterMonitoringMBeans();
                this.clusterMonitoringStarted = true;
            }
        }
    }

    public void stop() {
        ClusterManager clusterManager = this.clusterManagerRef.get();
        if (clusterManager.isClustered()) {
            ClusterServicesManager clusterServicesManager = this.clusterServicesManagerRef.get();
            clusterServicesManager.stopServices();
            if (this.clusterMonitoringStarted) {
                this.clusterMonitoringBeansRegistrar.unregisterClusterMonitorMBeans();
                this.clusterMonitoringStarted = false;
            }
        }
    }

    @VisibleForTesting
    void logWithPrefix(String message, Object ... arguments) {
        String nodeId = this.clusterManagerRef.get().getNodeId();
        log.info("[INDEX_START] Current node: {}. " + message, ObjectArrays.concat((Object)nodeId, (Object[])arguments));
    }

    @VisibleForTesting
    void logOnlineNodes() {
        Set onlineNodesStatuses = (Set)this.clusterManagerRef.get().getAllNodeStatuses().stream().filter(nodeStatus -> nodeStatus.getNodeState() != Node.NodeState.OFFLINE).collect(ImmutableSet.toImmutableSet());
        log.info("[INDEX_START] Nodes currently online: {}", (Object)onlineNodesStatuses);
    }
}

