/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.util.DefaultAttachmentConfigManager;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.config.util.StartupJiraHome;
import com.atlassian.jira.plugin.PluginPath;
import com.atlassian.jira.service.services.file.FileService;
import com.atlassian.jira.startup.ApplicationPropertiesJiraHomePathLocator;
import com.atlassian.jira.startup.CompositeJiraHomePathLocator;
import com.atlassian.jira.startup.JiraHomeLockAcquirer;
import com.atlassian.jira.startup.JiraHomePathLocator;
import com.atlassian.jira.startup.JiraHomeStartupCheckFailure;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.startup.SystemPropertyJiraHomePathLocator;
import com.atlassian.jira.startup.WebContextJiraHomePathLocator;
import com.atlassian.jira.util.PathUtils;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.ServletContextProvider;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import io.atlassian.util.concurrent.LazyReference;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraHomeStartupCheck
implements StartupCheck {
    private static final Logger log = LoggerFactory.getLogger(JiraHomeStartupCheck.class);
    private static JiraHomeStartupCheck HOME_STARTUP_CHECK;
    private static final CompositeJiraHomePathLocator pathLocator;
    private final JiraHomePathLocator locator;
    private final JiraHomeLockAcquirer lockAcquirer;
    private final LazyReference<Either<JiraHomeStartupCheckFailure, File>> homeDirRef = new LazyReference<Either<JiraHomeStartupCheckFailure, File>>(){

        protected Either<JiraHomeStartupCheckFailure, File> create() throws Exception {
            Either result = JiraHomeStartupCheck.this.getConfiguredJiraHome().flatMap(jiraHome -> JiraHomeStartupCheck.this.validateJiraHome(jiraHome));
            result.forEach(homeDir -> log.info("The jira.home directory '" + homeDir.getAbsolutePath() + "' is validated and locked for exclusive use by this instance."));
            return result;
        }
    };

    @ClusterSafe(value="Program Artifact")
    public static synchronized JiraHomeStartupCheck getInstance() {
        if (HOME_STARTUP_CHECK == null) {
            HOME_STARTUP_CHECK = new JiraHomeStartupCheck(pathLocator);
        }
        return HOME_STARTUP_CHECK;
    }

    @VisibleForTesting
    JiraHomeStartupCheck(JiraHomePathLocator locator) {
        this.locator = locator;
        this.lockAcquirer = new JiraHomeLockAcquirer();
    }

    @Override
    public String getName() {
        return "Jira.Home Startup Check";
    }

    @Override
    public boolean isOk() {
        return ((Either)this.homeDirRef.get()).isRight();
    }

    public boolean isInitialised() {
        return this.homeDirRef.isInitialized();
    }

    private Either<JiraHomeStartupCheckFailure, String> getConfiguredJiraHome() {
        String home = this.locator.getJiraHome();
        if (StringUtils.isBlank((CharSequence)home)) {
            return Either.left((Object)JiraHomeStartupCheckFailure.missingConfiguration(JiraHomeStartupCheckFailure.Reason.NOT_CONFIGURED));
        }
        return Either.right((Object)home);
    }

    private boolean findDirectory(File directoryToTraverse, File directoryToFind) {
        for (File currentDirectory = directoryToTraverse; currentDirectory != null; currentDirectory = currentDirectory.getParentFile()) {
            if (!currentDirectory.equals(directoryToFind)) continue;
            return true;
        }
        return false;
    }

    private Either<JiraHomeStartupCheckFailure, File> validateJiraHome(String jiraHome) {
        File proposedJiraHome = new File(jiraHome);
        return this.checkProposedHomeAbsolute(proposedJiraHome, jiraHome).flatMap(this::checkWebappPathCollision).flatMap(this::checkJiraHomeCreationIsPossible).flatMap(this::createJiraHomeAndSharedHome).flatMap(this::lockJiraHome);
    }

    private Either<JiraHomeStartupCheckFailure, File> createJiraHomeAndSharedHome(File proposedJiraHome) {
        try {
            return this.createLocalHomeDirectories(proposedJiraHome).flatMap(file -> this.createSharedHomeDirectories(new StartupJiraHome(this.locator).getHome(), (File)file));
        }
        catch (SecurityException ex) {
            return Either.left((Object)JiraHomeStartupCheckFailure.badProposedJiraHome(JiraHomeStartupCheckFailure.Reason.CREATION_FAILED_SECURITY, proposedJiraHome.getAbsolutePath()));
        }
    }

    private Either<JiraHomeStartupCheckFailure, File> checkJiraHomeCreationIsPossible(File proposedJiraHome) {
        if (proposedJiraHome.exists()) {
            if (!proposedJiraHome.isDirectory()) {
                return Either.left((Object)JiraHomeStartupCheckFailure.badProposedJiraHome(JiraHomeStartupCheckFailure.Reason.NOT_A_DIR, proposedJiraHome.getAbsolutePath()));
            }
        } else {
            log.info("Configured jira.home '" + proposedJiraHome.getAbsolutePath() + "' does not exist. We will create it.");
            try {
                if (!proposedJiraHome.mkdirs()) {
                    return Either.left((Object)JiraHomeStartupCheckFailure.badProposedJiraHome(JiraHomeStartupCheckFailure.Reason.CREATION_NOT_POSSIBLE, proposedJiraHome.getAbsolutePath()));
                }
            }
            catch (SecurityException ex) {
                return Either.left((Object)JiraHomeStartupCheckFailure.badProposedJiraHome(JiraHomeStartupCheckFailure.Reason.CREATION_FAILED_SECURITY, proposedJiraHome.getAbsolutePath()));
            }
        }
        return Either.right((Object)proposedJiraHome);
    }

    private Either<JiraHomeStartupCheckFailure, File> checkWebappPathCollision(File proposedJiraHome) {
        ServletContext servletContext = ServletContextProvider.getServletContext();
        if (servletContext == null) {
            log.error("No ServletContext exists - cannot check if jira.home is on the servlet path.");
        } else {
            String realPath = servletContext.getRealPath("/");
            if (realPath != null) {
                File webappServletPath = new File(realPath);
                if (proposedJiraHome.equals(webappServletPath)) {
                    return Either.left((Object)JiraHomeStartupCheckFailure.webappPathCollision(JiraHomeStartupCheckFailure.Reason.PATH_COLLISION_WEBAPP_SERVLET, proposedJiraHome.getAbsolutePath(), webappServletPath.getAbsolutePath()));
                }
                try {
                    if (PathUtils.isChildPath((File)proposedJiraHome, (File)webappServletPath)) {
                        return Either.left((Object)JiraHomeStartupCheckFailure.webappPathCollision(JiraHomeStartupCheckFailure.Reason.PATH_COLLISION_WEBAPP_SERVLET_PARENT, proposedJiraHome.getAbsolutePath(), webappServletPath.getAbsolutePath()));
                    }
                    if (PathUtils.isChildPath((File)webappServletPath, (File)proposedJiraHome)) {
                        return Either.left((Object)JiraHomeStartupCheckFailure.webappPathCollision(JiraHomeStartupCheckFailure.Reason.PATH_COLLISION_WEBAPP_SERVLET_CHILD, proposedJiraHome.getAbsolutePath(), webappServletPath.getAbsolutePath()));
                    }
                }
                catch (IOException e) {
                    log.error("Failed to check collision for JIRA home directory", (Throwable)e);
                    return Either.left((Object)JiraHomeStartupCheckFailure.webappPathCollision(JiraHomeStartupCheckFailure.Reason.PATH_COLLISION_WEBAPP_SERVLET_FAILED, proposedJiraHome.getAbsolutePath(), webappServletPath.getAbsolutePath()));
                }
            }
        }
        return Either.right((Object)proposedJiraHome);
    }

    private Either<JiraHomeStartupCheckFailure, File> checkProposedHomeAbsolute(File proposedJiraHome, String jiraHome) {
        if (!proposedJiraHome.isAbsolute()) {
            if (JiraSystemProperties.isDevMode()) {
                log.warn("jira.home is a relative path, but jira.dev.mode is set to true so we will allow this.");
            } else {
                boolean windowsLikeBackslash = JiraSystemProperties.getInstance().getProperty("file.separator").equals("\\");
                JiraHomeStartupCheckFailure.Reason failureReason = windowsLikeBackslash ? JiraHomeStartupCheckFailure.Reason.PATH_NOT_ABSOLUTE_BUT_WINDOWS_LIKE : JiraHomeStartupCheckFailure.Reason.PATH_NOT_ABSOLUTE;
                return Either.left((Object)JiraHomeStartupCheckFailure.badConfiguredJiraHome(failureReason, jiraHome));
            }
        }
        return Either.right((Object)proposedJiraHome);
    }

    private Either<JiraHomeStartupCheckFailure, File> createLocalHomeDirectories(File proposedJiraHome) {
        SortedSet subdirs = CollectionBuilder.newBuilder().add((Object)IndexPathManager.INDEXES_DIR).add((Object)"plugins").add((Object)PluginPath.INSTALLED_PLUGINS_SUBDIR).addAll((Collection)JiraHome.localsubdirs).add((Object)PathUtils.joinPaths((String[])new String[]{"caches", DefaultAttachmentConfigManager.getDefaultTempAttachmentDirectory()})).asMutableSortedSet();
        return this.createHomeDirectories(proposedJiraHome, subdirs, proposedJiraHome);
    }

    private Either<JiraHomeStartupCheckFailure, File> createSharedHomeDirectories(File sharedJiraHome, File proposedJiraHome) {
        SortedSet subdirs = CollectionBuilder.newBuilder().add((Object)PathUtils.joinPaths((String[])new String[]{"data", "attachments"})).add((Object)"plugins").add((Object)PluginPath.BUNDLED_SUBDIR).add((Object)PluginPath.OSGI_SUBDIR).add((Object)FileService.MAIL_DIR).addAll((Collection)JiraHome.sharedsubdirs).asMutableSortedSet();
        return this.createHomeDirectories(sharedJiraHome, subdirs, proposedJiraHome);
    }

    private Either<JiraHomeStartupCheckFailure, File> createHomeDirectories(File parentDirectory, Set<String> subdirs, File proposedJiraHome) {
        for (String subdir : subdirs) {
            try {
                File dir = new File(parentDirectory, subdir);
                if (this.canCreateAndWriteTo(dir)) continue;
                return Either.left((Object)JiraHomeStartupCheckFailure.badSubdirectory(JiraHomeStartupCheckFailure.Reason.CREATION_FAILED_WRITE_PERMISSION_SUBDIR, parentDirectory.getAbsolutePath(), subdir));
            }
            catch (Exception e) {
                return Either.left((Object)JiraHomeStartupCheckFailure.badSubdirectory(JiraHomeStartupCheckFailure.Reason.CREATION_FAILED_SUBDIR, parentDirectory.getAbsolutePath(), subdir));
            }
        }
        return Either.right((Object)proposedJiraHome);
    }

    private boolean canCreateAndWriteTo(File dir) {
        return dir.isDirectory() && dir.canWrite() || dir.mkdirs();
    }

    private Either<JiraHomeStartupCheckFailure, File> lockJiraHome(File proposedJiraHome) {
        Assertions.notNull((String)"You should not be in this method if you have a null lockAcquirer", (Object)this.lockAcquirer);
        try {
            JiraHomeLockAcquirer.LockResult result = this.lockAcquirer.acquire(proposedJiraHome);
            if (result != JiraHomeLockAcquirer.LockResult.OK) {
                if (result == JiraHomeLockAcquirer.LockResult.HELD_BY_OTHERS) {
                    return Either.left((Object)JiraHomeStartupCheckFailure.badProposedJiraHome(JiraHomeStartupCheckFailure.Reason.LOCK_ALREADY_EXISTS, proposedJiraHome.getAbsolutePath()));
                }
                return Either.left((Object)JiraHomeStartupCheckFailure.badProposedJiraHome(JiraHomeStartupCheckFailure.Reason.LOCK_FAILED_CREATION, proposedJiraHome.getAbsolutePath()));
            }
            return Either.right((Object)proposedJiraHome);
        }
        catch (Exception ex) {
            return Either.left((Object)JiraHomeStartupCheckFailure.badProposedJiraHome(JiraHomeStartupCheckFailure.Reason.LOCK_FAILED_CREATION, proposedJiraHome.getAbsolutePath()));
        }
    }

    @Override
    public void stop() {
        this.lockAcquirer.release();
    }

    public Either<JiraHomeStartupCheckFailure, File> getJiraHomeDirectory() {
        return (Either)this.homeDirRef.get();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    @Nullable
    public String getFaultDescription() {
        return null;
    }

    @Override
    @Nullable
    public String getHTMLFaultDescription() {
        return null;
    }

    static {
        pathLocator = new CompositeJiraHomePathLocator(new SystemPropertyJiraHomePathLocator(), new WebContextJiraHomePathLocator(), new ApplicationPropertiesJiraHomePathLocator());
    }
}

