/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.scheduler.cron.SimpleToCronTriggerConverter;
import com.atlassian.jira.web.component.admin.websudo.IPAllowListAnalyticsEvent;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSudoIPAllowListAnalyticsLauncher {
    private static final Logger log = LoggerFactory.getLogger(WebSudoIPAllowListAnalyticsLauncher.class);
    @VisibleForTesting
    final JobRunnerKey runnerKey = JobRunnerKey.of((String)(WebSudoIPAllowListAnalyticsLauncher.class.getName() + ".daily"));
    @VisibleForTesting
    SchedulerService schedulerService;

    public void start() {
        EventPublisher eventPublisher = (EventPublisher)ComponentAccessor.getComponentOfType(EventPublisher.class);
        ApplicationProperties applicationProperties = (ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class);
        if (eventPublisher != null && applicationProperties != null) {
            IPAllowListAnalyticsEvent analyticsEvent = this.instantiateAnalyticsEvent(applicationProperties);
            eventPublisher.publish((Object)analyticsEvent);
            this.schedulerService = (SchedulerService)ComponentAccessor.getComponent(SchedulerService.class);
            if (this.schedulerService != null) {
                this.schedulerService.registerJobRunner(this.runnerKey, r -> {
                    eventPublisher.publish((Object)analyticsEvent);
                    return JobRunnerResponse.success();
                });
                try {
                    this.schedulerService.scheduleJob(JobId.of((String)WebSudoIPAllowListAnalyticsLauncher.class.getName()), JobConfig.forJobRunnerKey((JobRunnerKey)this.runnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forCronExpression((String)this.constructCronString())));
                }
                catch (SchedulerServiceException e) {
                    log.error("Cannot schedule job for WebsudoIPAllowlist analytics", (Throwable)e);
                }
            } else {
                log.error("Cannot register scheduled job for WebsudoIPAllowlist analytics because scheduler service is null");
            }
        } else {
            log.error("Cannot emit IPAllowListAnalyticsEvent because eventPublisher and/or applicationProperties is null");
        }
    }

    @VisibleForTesting
    String constructCronString() {
        return new SimpleToCronTriggerConverter().convertToCronString((Date)Date.from((Instant)LocalTime.of((int)12, (int)3).atDate((LocalDate)LocalDate.now()).atZone((ZoneId)ZoneId.systemDefault()).toInstant()), (long)Duration.ofDays((long)1L).toMillis()).cronString;
    }

    public void stop() {
        if (this.schedulerService != null) {
            this.schedulerService.getJobsByJobRunnerKey(this.runnerKey).stream().map(JobDetails::getJobId).forEach(this::unscheduleJob);
        }
    }

    private void unscheduleJob(JobId jobId) {
        try {
            this.schedulerService.unscheduleJob(jobId);
        }
        catch (SchedulerRuntimeException sre) {
            log.warn("Scheduler failed to remove job {}", (Object)jobId, (Object)sre);
        }
    }

    IPAllowListAnalyticsEvent instantiateAnalyticsEvent(ApplicationProperties applicationProperties) {
        IPAllowListAnalyticsEvent event = new IPAllowListAnalyticsEvent();
        event.setEnabled(applicationProperties.getOption("websudo.allowlist.enabled"));
        event.setCustomHeader(!"X-Forwarded-For".equalsIgnoreCase(Optional.ofNullable(applicationProperties.getDefaultBackedString("server.tomcat.remoteip.remote-ip-header")).orElse("X-Forwarded-For")));
        event.setIpAddressIncluded(StringUtils.isNotBlank((CharSequence)applicationProperties.getDefaultBackedString("websudo.allowlist.ip")));
        event.setCidrIncluded(StringUtils.isNotBlank((CharSequence)applicationProperties.getDefaultBackedString("websudo.allowlist.cidr")));
        return event;
    }
}

