/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.mail.EmailTypes;
import com.atlassian.jira.mail.EmailTypesService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.DefaultEmailType;
import com.atlassian.jira.template.DefaultEmailTypes;
import com.atlassian.jira.template.TemplateValidationConfigProvider;
import com.atlassian.jira.template.TemplatesValidationConfig;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEmailTypesService
implements EmailTypesService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEmailTypesService.class);
    public static final String MAIL_BATCHING_FEATURE_KEY = "mail.batching";
    private final TemplateValidationConfigProvider templateValidationConfigProvider;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final FeatureManager featureManager;

    public DefaultEmailTypesService(TemplateValidationConfigProvider templateValidationConfigProvider, JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager, I18nHelper.BeanFactory i18nFactory, FeatureManager featureManager) {
        this.templateValidationConfigProvider = templateValidationConfigProvider;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.i18nFactory = i18nFactory;
        this.featureManager = featureManager;
    }

    public ServiceOutcome<EmailTypes> getEmailTypes() {
        try {
            if (!this.isAdmin()) {
                return ServiceOutcomeImpl.error(this.translate("admin.email.templates.forbidden.error"), ErrorCollection.Reason.FORBIDDEN);
            }
            String userEmailAddress = this.jiraAuthenticationContext.getLoggedInUser().getEmailAddress();
            if (StringUtils.isBlank((CharSequence)userEmailAddress)) {
                return ServiceOutcomeImpl.error(this.translate("admin.email.templates.user.email.missing"), ErrorCollection.Reason.VALIDATION_FAILED);
            }
            boolean mailBatchingEnabled = this.featureManager.isEnabled(MAIL_BATCHING_FEATURE_KEY);
            TemplatesValidationConfig templatesValidationConfig = this.templateValidationConfigProvider.get();
            Set<DefaultEmailType> emailTypeSet = templatesValidationConfig.getTemplateConfigs().values().stream().map(templateInfo -> DefaultEmailType.of(templateInfo, mailBatchingEnabled)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            LOG.debug("Email types: {}", emailTypeSet);
            return ServiceOutcomeImpl.ok(new DefaultEmailTypes(userEmailAddress, emailTypeSet));
        }
        catch (Exception e) {
            LOG.error("Unexpected error while reading email types", (Throwable)e);
            return ServiceOutcomeImpl.error(e.getMessage());
        }
    }

    private String translate(String msgKey) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(this.jiraAuthenticationContext.getLoggedInUser());
        return i18nHelper.getText(msgKey);
    }

    private boolean isAdmin() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return user != null && this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }
}

