/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.template.JiraHomeTemplatesRevertService;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DefaultJiraHomeTemplatesRevertService
implements JiraHomeTemplatesRevertService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJiraHomeTemplatesRevertService.class);
    protected static final String TEMP_DIR = "templates/email_UpgradeTaskTemp";
    protected static final String REVERT_TEMP_DIR = "templates/email_RevertTemp";
    protected static final String SHARE_PLUGIN_KEY = "com.atlassian.jira.jira-share-plugin";
    protected static final String BATCH_EMAILS_PLUGIN_KEY = "com.atlassian.jira.plugins.inform.batchers";
    protected static final String BATCH_EMAILS_SOURCE_PATH = "templates/email-batch/";
    public static final String BATCH_EMAILS_TARGET_PATH = "templates/email-batch/";
    protected static final String BATCH_EMAILS_TARGET_PATH_TEMP = "templates/email-batch_UpgradeTaskTemp/";
    protected static final String BATCH_EMAILS_REVERT_TEMP = "templates/email-batch_RevertTemp/";
    private static final String SUBJECT_TEMPLATE_TYPE = "subject";
    protected static final List<String> SHARE_PLUGIN_RESOURCES = Arrays.asList("templates/email/html/mobileSingleColumnStyle.vm", "templates/email/text/share-saved-search.vm", "templates/email/html/share-saved-search.vm", "templates/email/subject/share-saved-search.vm", "templates/email/text/share-jql-search.vm", "templates/email/html/share-jql-search.vm", "templates/email/subject/share-jql-search.vm", "templates/email/text/share-issue.vm", "templates/email/html/share-issue.vm", "templates/email/subject/share-issue.vm");
    protected static final List<String> BATCH_EMAILS_PLUGIN_RESOURCES = Arrays.asList("templates/email-batch/html/footer.vm", "templates/email-batch/html/hr-bottom.vm", "templates/email-batch/html/IssueUpdateBatcher.css", "templates/email-batch/html/IssueUpdateBatcher.vm", "templates/email-batch/html/IssueUpdateBatcher-content.vm", "templates/email-batch/html/IssueUpdateBatcher-header.vm", "templates/email-batch/html/IssueUpdateBatcher-history.vm", "templates/email-batch/html/IssueUpdateBatcher-subject.vm", "templates/email-batch/html/spacer.vm", "templates/email-batch/html/template.vm", "templates/email-batch/shared/mention-text.vm", "templates/email-batch/text/IssueUpdateBatcher.vm", "templates/email-batch/text/IssueUpdateBatcher-subject.vm");
    private final PluginAccessor pluginAccessor;
    protected final String templatesTargetLocation;
    protected final String batchTemplatesTargetLocation;
    protected final String templatesTargetLocationTemp;
    protected final String batchTemplatesTargetLocationTemp;
    protected final String templatesRevertTemp;
    protected final String batchTemplatesRevertTemp;

    public DefaultJiraHomeTemplatesRevertService(FileStores fileStores, PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        String dataDir = DefaultJiraHomeTemplatesRevertService.getDataDirPathPrefix(fileStores);
        this.templatesTargetLocation = dataDir + "templates/email/";
        this.templatesTargetLocationTemp = dataDir + TEMP_DIR;
        this.batchTemplatesTargetLocation = dataDir + "templates/email-batch/";
        this.batchTemplatesTargetLocationTemp = dataDir + BATCH_EMAILS_TARGET_PATH_TEMP;
        this.templatesRevertTemp = dataDir + REVERT_TEMP_DIR;
        this.batchTemplatesRevertTemp = dataDir + BATCH_EMAILS_REVERT_TEMP;
    }

    private static String getDataDirPathPrefix(FileStores fileStores) {
        return fileStores.getHomeFilesystemPath().path(new String[]{"data"}).asJavaFile().getPath() + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyMissingBundledTemplatesIntoJiraHome() throws IOException {
        try {
            boolean useTempDir = !this.dirExists(this.templatesTargetLocation);
            boolean useBatchTempDir = !this.dirExists(this.batchTemplatesTargetLocation);
            String targetLocation = useTempDir ? this.templatesTargetLocationTemp : this.templatesTargetLocation;
            String targetBatchLocation = useBatchTempDir ? this.batchTemplatesTargetLocationTemp : this.batchTemplatesTargetLocation;
            this.copyEmailTemplates(targetLocation);
            this.copySharePluginEmailTemplates(targetLocation);
            this.copyBatchingPluginEmailTemplates(targetBatchLocation);
            this.renameTempDirIfUsed(useTempDir, this.templatesTargetLocationTemp, this.templatesTargetLocation);
            this.renameTempDirIfUsed(useBatchTempDir, this.batchTemplatesTargetLocationTemp, this.batchTemplatesTargetLocation);
        }
        finally {
            this.cleanupDir(this.templatesTargetLocationTemp);
            this.cleanupDir(this.batchTemplatesTargetLocationTemp);
        }
    }

    @Override
    public void revertTemplates() throws IOException {
        try {
            this.cleanupDir(this.templatesRevertTemp);
            this.cleanupDir(this.batchTemplatesRevertTemp);
            this.copyEmailTemplates(this.templatesRevertTemp);
            this.copySharePluginEmailTemplates(this.templatesRevertTemp);
            this.copyBatchingPluginEmailTemplates(this.batchTemplatesRevertTemp);
            this.cleanupDir(this.templatesTargetLocation);
            this.renameTempDirIfUsed(true, this.templatesRevertTemp, this.templatesTargetLocation);
            this.cleanupDir(this.batchTemplatesTargetLocation);
            this.renameTempDirIfUsed(true, this.batchTemplatesRevertTemp, this.batchTemplatesTargetLocation);
        }
        finally {
            this.cleanupDir(this.templatesRevertTemp);
            this.cleanupDir(this.batchTemplatesRevertTemp);
        }
    }

    private void renameTempDirIfUsed(boolean useTempDir, String tempLocation, String targetLocation) throws IOException {
        if (useTempDir && this.dirExists(tempLocation)) {
            LOGGER.info("Renaming temporary directory '{}' to '{}", (Object)tempLocation, (Object)targetLocation);
            this.renameTempDir(tempLocation, targetLocation);
        }
    }

    private void copyEmailTemplates(String targetDir) throws IOException {
        PathMatchingResourcePatternResolver resolver = this.newResourceResolver();
        Resource[] resources = resolver.getResources("classpath*:templates/email/**");
        int filesCount = 0;
        int copiedCount = 0;
        for (Resource resource : resources) {
            if (resource.exists() && resource.isReadable() && resource.contentLength() > 0L) {
                ++filesCount;
                if (!this.copyResource(resource.getURL(), "templates/email/", targetDir)) continue;
                ++copiedCount;
                continue;
            }
            LOGGER.info("Did not copy, seems to be directory: '{}'", (Object)resource.getDescription());
        }
        LOGGER.info("Copied {}/{}", (Object)copiedCount, (Object)filesCount);
    }

    private void copySharePluginEmailTemplates(String targetDir) throws IOException {
        this.copyPluginEmailTemplates(SHARE_PLUGIN_KEY, SHARE_PLUGIN_RESOURCES, "templates/email/", targetDir);
    }

    private void copyBatchingPluginEmailTemplates(String targetDir) throws IOException {
        this.copyPluginEmailTemplates(BATCH_EMAILS_PLUGIN_KEY, BATCH_EMAILS_PLUGIN_RESOURCES, "templates/email-batch/", targetDir);
    }

    private void copyPluginEmailTemplates(String pluginKey, List<String> pluginResources, String sourceDir, String targetDir) throws IOException {
        LOGGER.info("Copying email templates from '{}'", (Object)pluginKey);
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin != null) {
            int copiedCount = 0;
            for (String resourcePath : pluginResources) {
                URL url = plugin.getResource(resourcePath);
                if (url != null) {
                    if (!this.copyResource(url, sourceDir, targetDir)) continue;
                    ++copiedCount;
                    continue;
                }
                LOGGER.warn("Missing template: '{}'", (Object)resourcePath);
            }
            LOGGER.info("Copied {}/{}", (Object)copiedCount, (Object)pluginResources.size());
        } else {
            LOGGER.warn("'{}' plugin is not available", (Object)pluginKey);
        }
    }

    private boolean copyResource(URL url, String sourceDir, String targetDir) throws IOException {
        String urlString = url.toExternalForm();
        String targetName = urlString.substring(urlString.indexOf(sourceDir) + sourceDir.length());
        File destinationFile = this.newFile(targetDir, targetName);
        if (!destinationFile.exists()) {
            this.copyUrlToFile(url, destinationFile);
            LOGGER.info("Copied resource to Shared Jira Home. source:'{}', destination:'{}'", (Object)urlString, (Object)destinationFile.getAbsolutePath());
            return true;
        }
        LOGGER.info("Skipping resource as it already exists in Shared Jira Home. source:'{}', destination:'{}'", (Object)urlString, (Object)destinationFile.getAbsolutePath());
        return false;
    }

    @VisibleForTesting
    protected boolean dirExists(String path) {
        return new File(path).exists();
    }

    @VisibleForTesting
    protected void renameTempDir(String source, String destination) throws IOException {
        FileUtils.moveDirectory((File)new File(source), (File)new File(destination));
    }

    @VisibleForTesting
    protected void cleanupDir(String tempDir) throws IOException {
        FileUtils.deleteDirectory((File)new File(tempDir));
    }

    @VisibleForTesting
    protected PathMatchingResourcePatternResolver newResourceResolver() {
        return new PathMatchingResourcePatternResolver();
    }

    @VisibleForTesting
    protected File newFile(String targetDir, String targetName) {
        return new File(targetDir, targetName);
    }

    @VisibleForTesting
    protected void copyUrlToFile(URL url, File destination) throws IOException {
        FileUtils.copyURLToFile((URL)url, (File)destination);
    }
}

