/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.event.mail.template.EmailTemplatesAppliedEvent;
import com.atlassian.jira.event.mail.template.EmailTemplatesDownloadedEvent;
import com.atlassian.jira.event.mail.template.EmailTemplatesRevertedEvent;
import com.atlassian.jira.event.mail.template.EmailTemplatesUploadedEvent;
import com.atlassian.jira.event.mail.template.EmailTemplatesValidatedEvent;
import com.atlassian.jira.mail.MailTemplatesService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.CachingJiraHomeTemplateContentLoader;
import com.atlassian.jira.template.JiraHomeTemplatesRevertService;
import com.atlassian.jira.template.validator.TemplateValidatorService;
import com.atlassian.jira.template.velocity.EmailVelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.ZipUtils;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DefaultMailTemplatesService
implements MailTemplatesService {
    private static final Logger log = LoggerFactory.getLogger(DefaultMailTemplatesService.class);
    protected static final String TEMPLATES = "templates";
    protected static final String EMAIL_DIR = "email";
    protected static final String EMAIL_BATCH_DIR = "email-batch";
    private static final String TEMPLATES_TEMP_ZIP_FILE = "temp_templates.zip";
    protected static final String TEMP_SUFFIX = "_temp";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String LOCK_NAME = DefaultMailTemplatesService.class.getName() + "_lock";
    private static final long LOCK_WAIT_SECONDS = 3L;
    private final FileStores fileStores;
    private final GlobalPermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final I18nHelper.BeanFactory i18nFactory;
    private final CachingJiraHomeTemplateContentLoader cachingTemplateLoader;
    private final EmailVelocityTemplatingEngine templatingEngine;
    private final ClusterLockService clusterLockService;
    private final TemplateValidatorService templateValidatorService;
    private final JiraHomeTemplatesRevertService jiraHomeTemplatesRevertService;
    private final EventPublisher eventPublisher;
    private final String templatesDir;

    public DefaultMailTemplatesService(FileStores fileStores, GlobalPermissionManager permissionManager, JiraAuthenticationContext authenticationContext, I18nHelper.BeanFactory i18nFactory, CachingJiraHomeTemplateContentLoader cachingTemplateLoader, EmailVelocityTemplatingEngine templatingEngine, ClusterLockService clusterLockService, TemplateValidatorService templateValidatorService, JiraHomeTemplatesRevertService jiraHomeTemplatesRevertService, EventPublisher eventPublisher) {
        this.fileStores = (FileStores)Assertions.notNull((String)"fileStores", (Object)fileStores);
        this.permissionManager = (GlobalPermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.authenticationContext = (JiraAuthenticationContext)Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        this.i18nFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18nFactory", (Object)i18nFactory);
        this.cachingTemplateLoader = (CachingJiraHomeTemplateContentLoader)Assertions.notNull((String)"cachingTemplateLoader", (Object)cachingTemplateLoader);
        this.templatingEngine = (EmailVelocityTemplatingEngine)Assertions.notNull((String)"templatingEngine", (Object)templatingEngine);
        this.clusterLockService = (ClusterLockService)Assertions.notNull((String)"clusterLockService", (Object)clusterLockService);
        this.templateValidatorService = templateValidatorService;
        this.jiraHomeTemplatesRevertService = jiraHomeTemplatesRevertService;
        this.eventPublisher = eventPublisher;
        this.templatesDir = fileStores.getHomeFilesystemPath().path(new String[]{"data", TEMPLATES}).asJavaFile().getPath();
    }

    public ServiceOutcome<Void> uploadEmailTemplates(InputStream templatesStream) {
        ServiceOutcome<Void> permissionCheck = this.checkPermissions();
        if (!permissionCheck.isValid()) {
            return permissionCheck;
        }
        ServiceOutcome outcome = this.runInClusterLock(() -> {
            ServiceOutcome<Void> uploadOutcome = this.uploadTemplates(templatesStream);
            boolean uploadValid = uploadOutcome.isValid();
            this.eventPublisher.publish((Object)new EmailTemplatesUploadedEvent(this.getUser(), uploadValid));
            if (!uploadValid) {
                return uploadOutcome;
            }
            ServiceOutcome<Void> validationOutcome = this.templateValidatorService.validateTemplatesFolder(this.templatesDir + TEMP_SUFFIX);
            if (!validationOutcome.isValid()) {
                this.eventPublisher.publish((Object)new EmailTemplatesValidatedEvent(this.getUser(), EmailTemplatesValidatedEvent.ValidationFailureReason.MISSING_FILES));
                this.quietlyDeleteDirectory(this.newFile(this.templatesDir + TEMP_SUFFIX));
            } else {
                this.eventPublisher.publish((Object)new EmailTemplatesValidatedEvent(this.getUser()));
            }
            return validationOutcome;
        });
        return outcome;
    }

    public ServiceOutcome<Void> applyEmailTemplates() {
        ServiceOutcome<Void> permissionCheck = this.checkPermissions();
        if (!permissionCheck.isValid()) {
            return permissionCheck;
        }
        ServiceOutcome outcome = this.runInClusterLock(this::applyTemplates);
        this.eventPublisher.publish((Object)new EmailTemplatesAppliedEvent(this.getUser(), outcome.isValid()));
        return outcome;
    }

    public ServiceOutcome<File> getEmailTemplatesZip() {
        ServiceOutcome<Void> permissionCheck = this.checkPermissions();
        if (!permissionCheck.isValid()) {
            return ServiceOutcomeImpl.from(permissionCheck.getErrorCollection());
        }
        ServiceOutcome outcome = this.runInClusterLock(() -> {
            try {
                File zipFile = this.getTemplatesZip(this.templatesDir);
                return ServiceOutcomeImpl.ok(zipFile);
            }
            catch (FileNotFoundException e) {
                log.error("Templates folder not found", (Throwable)e);
                return ServiceOutcomeImpl.error(this.getLocalizedError("admin.email.templates.downloading.error.no.folder.found"));
            }
        });
        this.emitTemplatesDownloadedEvent(outcome);
        return outcome;
    }

    public ServiceOutcome<Void> revertEmailTemplatesToDefault() {
        ServiceOutcome<Void> permissionCheck = this.checkPermissions();
        if (!permissionCheck.isValid()) {
            return ServiceOutcomeImpl.from(permissionCheck.getErrorCollection());
        }
        ServiceOutcome outcome = this.runInClusterLock(() -> {
            this.jiraHomeTemplatesRevertService.revertTemplates();
            this.cachingTemplateLoader.clearCssCache();
            this.cachingTemplateLoader.clearTemplatesCache();
            this.templatingEngine.clearCache();
            return ServiceOutcomeImpl.ok(null);
        });
        this.eventPublisher.publish((Object)new EmailTemplatesRevertedEvent(this.getUser(), outcome.isValid()));
        return outcome;
    }

    private ServiceOutcome<Void> checkPermissions() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null || !this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user)) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            I18nHelper i18nFactoryCustom = this.i18nFactory.getInstance(user);
            errorCollection.addErrorMessage(i18nFactoryCustom.getText("admin.email.templates.forbidden.error"), ErrorCollection.Reason.FORBIDDEN);
            return ServiceOutcomeImpl.from((ErrorCollection)errorCollection);
        }
        return ServiceOutcomeImpl.ok(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ServiceOutcome<T> runInClusterLock(Callable<ServiceOutcome<T>> callable) {
        ClusterLock clusterLock = this.clusterLockService.getLockForName(LOCK_NAME);
        boolean lockAcquired = false;
        try {
            lockAcquired = clusterLock.tryLock(3L, TimeUnit.SECONDS);
            if (!lockAcquired) {
                ServiceOutcomeImpl serviceOutcomeImpl = ServiceOutcomeImpl.error(this.getLocalizedErrorForLockRefused());
                return serviceOutcomeImpl;
            }
            ServiceOutcome<T> serviceOutcome = callable.call();
            return serviceOutcome;
        }
        catch (InterruptedException e) {
            log.error("Templates operation started, but could not be finished, thread has been interrupted while waiting for a cluster lock.", (Throwable)e);
            Thread.currentThread().interrupt();
            ServiceOutcomeImpl serviceOutcomeImpl = ServiceOutcomeImpl.error(this.getLocalizedError("admin.email.templates.error.internal.generic") + " " + e.getMessage());
            return serviceOutcomeImpl;
        }
        catch (Exception e) {
            log.error("Templates operation started, but could not be finished due to an error.", (Throwable)e);
            ServiceOutcomeImpl serviceOutcomeImpl = ServiceOutcomeImpl.error(this.getLocalizedError("admin.email.templates.error.internal.generic") + " " + e.getMessage());
            return serviceOutcomeImpl;
        }
        finally {
            if (lockAcquired) {
                clusterLock.unlock();
            }
        }
    }

    private File getTemplatesZip(String templatesPath) throws IOException {
        File zippedTemplates = this.newJiraFile(TEMPLATES);
        this.zipFolder(new File(templatesPath), zippedTemplates);
        return zippedTemplates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceOutcome<Void> uploadTemplates(InputStream templatesStream) {
        File zipFile = this.newFile(this.fileStores.getHomeFilesystemPath().path(new String[]{"data", TEMPLATES_TEMP_ZIP_FILE}).asJavaFile().getPath());
        File tempDestinationDir = this.newFile(this.templatesDir + TEMP_SUFFIX);
        try {
            this.extractZipStreamToTempTemplatesDirectory(tempDestinationDir, zipFile, templatesStream);
        }
        catch (Exception e) {
            log.error("Could not upload email templates", (Throwable)e);
            ServiceOutcomeImpl<Void> serviceOutcomeImpl = ServiceOutcomeImpl.error(this.getLocalizedErrorForUpload() + " " + e.getMessage());
            return serviceOutcomeImpl;
        }
        finally {
            this.quietlyDeleteIfExists(zipFile.toPath());
        }
        return ServiceOutcomeImpl.ok(null);
    }

    private ServiceOutcome<Void> applyTemplates() {
        File oldDestinationDir = this.newFile(this.templatesDir);
        File tempDestinationDir = this.newFile(this.templatesDir + TEMP_SUFFIX);
        try {
            if (!tempDestinationDir.exists()) {
                return ServiceOutcomeImpl.error(this.getLocalizedError("admin.email.templates.applying.error.no.temp.folder"), ErrorCollection.Reason.VALIDATION_FAILED);
            }
            this.replaceTemplates(oldDestinationDir, tempDestinationDir);
            this.cachingTemplateLoader.clearCssCache();
            this.cachingTemplateLoader.clearTemplatesCache();
            this.templatingEngine.clearCache();
        }
        catch (Exception e) {
            log.error("Applying templates started, but could not be finished due to an error.", (Throwable)e);
            return ServiceOutcomeImpl.error(this.getLocalizedError("admin.email.templates.applying.error.internal") + " " + e.getMessage());
        }
        return ServiceOutcomeImpl.ok(null);
    }

    private void extractZipStreamToTempTemplatesDirectory(File tempDestinationDir, File zipFile, InputStream templatesStream) throws IOException {
        if (tempDestinationDir.exists()) {
            this.deleteDirectory(tempDestinationDir);
        }
        this.deleteIfExists(zipFile.toPath());
        this.copyInputStreamToFile(templatesStream, zipFile);
        this.unzip(zipFile, tempDestinationDir);
        this.moveUpEmailDirsIfNested();
    }

    private void moveUpEmailDirsIfNested() throws IOException {
        File nestedEmailDir = this.newFile(this.templatesDir + TEMP_SUFFIX + File.separator + TEMPLATES + File.separator + EMAIL_DIR);
        File nestedEmailBatchDir = this.newFile(this.templatesDir + TEMP_SUFFIX + File.separator + TEMPLATES + File.separator + EMAIL_BATCH_DIR);
        if (nestedEmailDir.exists()) {
            this.moveDirectory(nestedEmailDir, this.newFile(this.templatesDir + TEMP_SUFFIX + File.separator + EMAIL_DIR));
        }
        if (nestedEmailBatchDir.exists()) {
            this.moveDirectory(nestedEmailBatchDir, this.newFile(this.templatesDir + TEMP_SUFFIX + File.separator + EMAIL_BATCH_DIR));
        }
        this.deleteDirectory(this.newFile(this.templatesDir + TEMP_SUFFIX + File.separator + TEMPLATES));
    }

    private void replaceTemplates(File oldDestinationDir, File tempDestinationDir) throws IOException {
        if (oldDestinationDir.exists()) {
            this.deleteDirectory(oldDestinationDir);
        }
        this.moveDirectory(tempDestinationDir, oldDestinationDir);
    }

    private String getLocalizedError(String key) {
        return this.i18nFactory.getInstance(this.authenticationContext.getLoggedInUser()).getText(key);
    }

    @VisibleForTesting
    protected String getLocalizedErrorForUpload() {
        return this.getLocalizedError("admin.email.templates.uploading.error.internal");
    }

    @VisibleForTesting
    protected String getLocalizedErrorForLockRefused() {
        return this.getLocalizedError("admin.email.templates.error.lock.refused");
    }

    private void emitTemplatesDownloadedEvent(ServiceOutcome<File> outcome) {
        this.eventPublisher.publish((Object)new EmailTemplatesDownloadedEvent(this.getUser(), outcome.isValid()));
    }

    private ApplicationUser getUser() {
        return this.authenticationContext.getLoggedInUser();
    }

    @VisibleForTesting
    protected void deleteIfExists(@NotNull Path path) throws IOException {
        Files.deleteIfExists(path);
    }

    @VisibleForTesting
    protected File newJiraFile(String templatesFileName) {
        return this.fileStores.getHomeFilesystemPath().path(new String[]{"export", templatesFileName + ZIP_EXTENSION}).asJavaFile();
    }

    @VisibleForTesting
    protected void zipFolder(File sourceFolder, File destination) throws IOException {
        File parentDir = destination.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        ZipUtils.zip(sourceFolder, destination);
    }

    @VisibleForTesting
    protected void quietlyDeleteIfExists(@NotNull Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            log.error("Exception while deleting the file", (Throwable)e);
        }
    }

    @VisibleForTesting
    protected void copyInputStreamToFile(@NotNull InputStream inputStream, @NotNull File file) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
    }

    @VisibleForTesting
    protected void unzip(File file, File outputDir) throws IOException {
        ZipUtils.unzip(file, outputDir);
    }

    @VisibleForTesting
    protected void deleteDirectory(@NotNull File directory) throws IOException {
        FileUtils.deleteDirectory((File)directory);
    }

    @VisibleForTesting
    protected void quietlyDeleteDirectory(@NotNull File directory) {
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            log.error("Exception while deleting the directory", (Throwable)e);
        }
    }

    @VisibleForTesting
    protected void moveDirectory(@NotNull File srcDir, @NotNull File destDir) throws IOException {
        FileUtils.moveDirectory((File)srcDir, (File)destDir);
    }

    @VisibleForTesting
    protected File newFile(@NotNull String pathname) {
        return new File(pathname);
    }
}

