/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateValidationConfigProvider;
import com.atlassian.jira.template.TemplatesValidationConfig;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.InjectableComponent;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class DefaultTemplateValidationConfigProvider
implements TemplateValidationConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTemplateValidationConfigProvider.class);
    private static final String TEMPLATES_CONFIG_FILE = "email-templates-to-validate.xml";
    private static final String HTML_ELEMENT = "html";
    private static final String TEXT_ELEMENT = "text";
    private static final String TEMPLATE_INFO_ELEMENT = "templateinfo";
    private static final String USE_FOR_VALIDATION_ELEMENT = "useForValidation";
    private static final String USE_FOR_TEST_EMAIL_ELEMENT = "useForTestEmail";
    private static final String TEMPLATE_ELEMENT = "template";
    private static final String FOLDER_ELEMENT = "folder";
    private static final String ID_ELEMENT = "id";
    private static final String NAME_ELEMENT = "name";
    private static final String USED_WHEN_BATCHING_ENABLED_ELEMENT = "usedWhenBatchingEnabled";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final I18nHelper.BeanFactory i18nFactory;
    private final TemplatesValidationConfig templatesValidationConfig;

    public DefaultTemplateValidationConfigProvider(JiraAuthenticationContext jiraAuthenticationContext, I18nHelper.BeanFactory i18nFactory) throws ParseException {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.i18nFactory = i18nFactory;
        this.templatesValidationConfig = new TemplatesValidationConfig(this.readTemplates());
    }

    @Override
    public TemplatesValidationConfig get() {
        return this.templatesValidationConfig;
    }

    private Map<Long, TemplatesValidationConfig.TemplateInfo> readTemplates() throws ParseException {
        LOG.info("Started parsing of {}", (Object)TEMPLATES_CONFIG_FILE);
        I18nHelper i18nHelper = this.i18nFactory.getInstance(this.jiraAuthenticationContext.getLoggedInUser());
        HashMap<Long, TemplatesValidationConfig.TemplateInfo> templatesMap = new HashMap<Long, TemplatesValidationConfig.TemplateInfo>();
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)TEMPLATES_CONFIG_FILE, this.getClass());
        Document doc = new Document(is);
        Elements templateElements = doc.getRoot().getElements(TEMPLATE_INFO_ELEMENT);
        while (templateElements.hasMoreElements()) {
            Element templateElement = (Element)templateElements.nextElement();
            TemplatesValidationConfig.TemplateInfo templateInfo = new TemplatesValidationConfig.TemplateInfo(templateElement.getLong(ID_ELEMENT), i18nHelper.getText(templateElement.getString(NAME_ELEMENT)), templateElement.getString(TEMPLATE_ELEMENT), templateElement.getString(FOLDER_ELEMENT), templateElement.getBoolean(HTML_ELEMENT), templateElement.getBoolean(TEXT_ELEMENT), templateElement.getBoolean(USED_WHEN_BATCHING_ENABLED_ELEMENT), templateElement.getBoolean(USE_FOR_VALIDATION_ELEMENT), templateElement.getBoolean(USE_FOR_TEST_EMAIL_ELEMENT));
            templatesMap.put(templateInfo.getId(), templateInfo);
            LOG.debug("Parsed template: {}", (Object)templateInfo);
        }
        LOG.info("Parsed {} template configs", (Object)templateElements.getNodeList().getLength());
        return templatesMap;
    }
}

