/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.themes.user;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.jira.external.ExternalRuntimeException;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.theme.api.Theme;
import com.atlassian.theme.api.ThemeColorMode;
import com.atlassian.theme.internal.api.ThemeService;
import com.atlassian.theme.internal.api.user.PreferredColorMode;
import com.atlassian.theme.internal.api.user.UserThemeService;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class DefaultUserThemeService
implements UserThemeService {
    private static final String PREFERRED_COLOR_MODE_KEY = "atl-theme-preferred-color-mode";
    private static final String PREFERRED_DARK_THEME = "atl-theme-preferred-dark-theme";
    private static final String PREFERRED_LIGHT_THEME = "atl-theme-preferred-light-theme";
    private static final String USER_KEY = "userKey";
    private final ThemeService themeService;
    private final UserManager userManager;
    private final UserPreferencesManager userPreferencesManager;

    public DefaultUserThemeService(@Nonnull ThemeService themeService, @Nonnull UserManager userManager, @Nonnull UserPreferencesManager userPreferencesManager) {
        this.themeService = Objects.requireNonNull(themeService, "themeService");
        this.userManager = Objects.requireNonNull(userManager, "userManager");
        this.userPreferencesManager = Objects.requireNonNull(userPreferencesManager, "userPreferencesManager");
    }

    public Optional<PreferredColorMode> getPreferredColorMode(UserKey userKey) {
        Objects.requireNonNull(userKey, USER_KEY);
        return Optional.ofNullable(this.getUserPreferences(userKey).getString(PREFERRED_COLOR_MODE_KEY)).flatMap(PreferredColorMode::optionalValueOf);
    }

    public Optional<Theme> getPreferredDarkTheme(UserKey userKey) {
        Objects.requireNonNull(userKey, USER_KEY);
        return this.themeService.findMatchingTheme(ThemeColorMode.DARK, this.getUserPreferences(userKey).getString(PREFERRED_DARK_THEME));
    }

    public Optional<Theme> getPreferredLightTheme(UserKey userKey) {
        Objects.requireNonNull(userKey, USER_KEY);
        return this.themeService.findMatchingTheme(ThemeColorMode.LIGHT, this.getUserPreferences(userKey).getString(PREFERRED_LIGHT_THEME));
    }

    public void setPreferredColorMode(UserKey userKey, PreferredColorMode preferredColorMode) {
        Objects.requireNonNull(userKey, USER_KEY);
        Objects.requireNonNull(preferredColorMode, "preferredColorMode");
        try {
            this.getUserPreferences(userKey).setString(PREFERRED_COLOR_MODE_KEY, preferredColorMode.toString());
        }
        catch (AtlassianCoreException e) {
            throw new ExternalRuntimeException(e);
        }
    }

    public void setPreferredDarkTheme(UserKey userKey, Theme theme) {
        Objects.requireNonNull(userKey, USER_KEY);
        Objects.requireNonNull(theme, "theme");
        try {
            this.getUserPreferences(userKey).setString(PREFERRED_DARK_THEME, theme.getThemeKey());
        }
        catch (AtlassianCoreException e) {
            throw new ExternalRuntimeException(e);
        }
    }

    public void setPreferredLightTheme(UserKey userKey, Theme theme) {
        Objects.requireNonNull(userKey, USER_KEY);
        Objects.requireNonNull(theme, "theme");
        try {
            this.getUserPreferences(userKey).setString(PREFERRED_LIGHT_THEME, theme.getThemeKey());
        }
        catch (AtlassianCoreException e) {
            throw new ExternalRuntimeException(e);
        }
    }

    private ExtendedPreferences getUserPreferences(@Nonnull UserKey userKey) {
        Objects.requireNonNull(userKey, USER_KEY);
        return this.userPreferencesManager.getExtendedPreferences(this.userManager.getUserByKey(userKey.getStringValue()));
    }
}

