/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.timezone;

import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class GMTOffsetConverter
implements Function<TimeZone, String> {
    public static final GMTOffsetConverter GMT_OFFSET_CONVERTER = new GMTOffsetConverter();

    @Override
    public String apply(TimeZone timeZone) {
        int rawOffset = timeZone.getRawOffset();
        String prefix = "+";
        if (rawOffset < 0) {
            prefix = "-";
        }
        rawOffset = rawOffset < 0 ? rawOffset * -1 : rawOffset;
        long hours = TimeUnit.HOURS.convert(rawOffset, TimeUnit.MILLISECONDS);
        long remainingOffset = (long)rawOffset - TimeUnit.MILLISECONDS.convert(hours, TimeUnit.HOURS);
        long minutes = TimeUnit.MINUTES.convert(remainingOffset, TimeUnit.MILLISECONDS);
        return String.format("(GMT%s%02d:%02d)", prefix, hours, minutes);
    }
}

