/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.cluster.ClusterInfo;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.IndexingConfiguration;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.event.JiraListener;
import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.event.listeners.history.IssueAssignHistoryListener;
import com.atlassian.jira.event.listeners.mail.MailListener;
import com.atlassian.jira.event.listeners.search.IssueIndexListener;
import com.atlassian.jira.index.LuceneCorruptionChecker;
import com.atlassian.jira.index.ObsoleteIndexCleaner;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.upgrade.ConsistencyChecker;
import com.atlassian.jira.upgrade.UntranslatedKeyFixer;
import com.atlassian.jira.util.CompositeShutdown;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.LuceneDirectoryUtils;
import com.atlassian.jira.util.Shutdown;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.johnson.JiraJohnsonContainer;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.system.check.SystemEnvironmentChecklist;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.lucene.search.BooleanQuery;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyCheckerImpl
implements ConsistencyChecker {
    @VisibleForTesting
    static final String INITIALISED = ConsistencyCheckerImpl.class.getName() + ":initialized";
    private static final Logger log = LoggerFactory.getLogger(ConsistencyCheckerImpl.class);
    private final JiraStartupLogger startupLog;
    private final JohnsonProvider johnsonProvider;
    private final Supplier<ClusterInfo> clusterInfoSupplier;

    public static ConsistencyChecker getInstance(JohnsonProvider johnsonProvider) {
        return new ConsistencyCheckerImpl(johnsonProvider, ComponentAccessor.supplierOf(ClusterInfo.class));
    }

    public ConsistencyCheckerImpl(JohnsonProvider johnsonProvider, Supplier<ClusterInfo> clusterInfoSupplier) {
        this.clusterInfoSupplier = Objects.requireNonNull(clusterInfoSupplier);
        this.johnsonProvider = Objects.requireNonNull(johnsonProvider);
        this.startupLog = new JiraStartupLogger();
    }

    @Override
    public void destroy(ServletContext context) {
        Object initialized = context.getAttribute(INITIALISED);
        if (Boolean.TRUE.equals(initialized)) {
            this.destroyServices();
            this.shutDown();
        }
    }

    private void destroyServices() {
        this.getServices().stream().filter(Objects::nonNull).forEach(service -> {
            try {
                service.destroy();
            }
            catch (RuntimeException e) {
                String serviceName = StringUtils.defaultString((String)service.getName(), (String)"Unknown");
                log.error("Failed to destroy service '" + serviceName + "'", (Throwable)e);
            }
        });
    }

    private void shutDown() {
        try {
            this.getShutdown().shutdown();
        }
        catch (RuntimeException e) {
            log.error("Failed to run shutdown hooks.", (Throwable)e);
        }
    }

    private Shutdown getShutdown() {
        return new CompositeShutdown(this.getIndexManagerShutdown(), () -> this.getTaskManager().shutdownAndWait(0L, TimeUnit.SECONDS));
    }

    @VisibleForTesting
    IndexLifecycleManager getIndexManager() {
        return (IndexLifecycleManager)ComponentAccessor.getComponent(IndexLifecycleManager.class);
    }

    private LuceneDirectoryUtils getLuceneDirectoryUtils() {
        return (LuceneDirectoryUtils)ComponentAccessor.getComponent(LuceneDirectoryUtils.class);
    }

    LuceneCorruptionChecker getLuceneCorruptionChecker() {
        return new LuceneCorruptionChecker(this.getLuceneDirectoryUtils(), (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class), (ClusterInfo)ComponentAccessor.getComponent(ClusterInfo.class));
    }

    private Shutdown getIndexManagerShutdown() {
        try {
            return this.getIndexManager();
        }
        catch (RuntimeException e) {
            log.error("Failed to get IndexManager, cannot shut it down cleanly...", (Throwable)e);
            return new Shutdown(){

                public void shutdown() {
                }

                public String toString() {
                    return "NullShutdownForIndexManager";
                }
            };
        }
    }

    @VisibleForTesting
    TaskManager getTaskManager() {
        return (TaskManager)ComponentAccessor.getComponent(TaskManager.class);
    }

    @VisibleForTesting
    Collection<JiraServiceContainer> getServices() {
        return ((ServiceManager)ComponentAccessor.getComponent(ServiceManager.class)).getServices();
    }

    @Override
    public void initialise(ServletContext servletContext) {
        this.setStartupTime(servletContext);
        this.checkConsistency();
        this.removeObsoleteIndex();
        this.checkAndInitLucene();
        this.checkUntranslatedKeyFixer();
        this.printJIRAStartupMessage();
        servletContext.setAttribute(INITIALISED, (Object)true);
    }

    private void removeObsoleteIndex() {
        new ObsoleteIndexCleaner((JiraHome)ComponentAccessor.getComponent(JiraHome.class), (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class)).deleteObsoleteIndexes();
    }

    private void printJIRAStartupMessage() {
        JiraJohnsonContainer eventCont = this.johnsonProvider.getContainer();
        if (!eventCont.hasEventThatPreventsStartup()) {
            this.startupLog.printStartedMessage();
        }
        this.checkSystemEnvironment();
    }

    private void checkConsistency() {
        try {
            log.info("Checking JIRA consistency");
            this.checkDataConsistency();
        }
        catch (Exception dataConsistencyCheckException) {
            log.error("An error occurred during the consistency check", (Throwable)dataConsistencyCheckException);
        }
    }

    @Override
    public void checkDataConsistency() throws Exception {
        this.checkMailListenerAndService();
        this.checkIssueAssignHistoryListener();
        this.checkIndexingSetup();
        this.checkLanguageExists();
        this.logServerId();
    }

    private void checkSystemEnvironment() {
        SystemEnvironmentChecklist.getEnglishWarningMessages().forEach(message -> this.startupLog.printMessage((String)message, Level.WARN));
    }

    private void checkAndInitLucene() {
        ApplicationProperties ap = ComponentAccessor.getApplicationProperties();
        IndexLifecycleManager indexManager = this.getIndexManager();
        Collection allIndexPaths = indexManager.getAllIndexPaths();
        int maxClausesCount = 65000;
        try {
            maxClausesCount = Integer.parseInt(ap.getDefaultBackedString("jira.search.maxclauses"));
        }
        catch (NumberFormatException e) {
            log.warn("Could not read the property 'jira.search.maxclauses' for the number of maximum search clauses. Using default " + maxClausesCount);
        }
        BooleanQuery.setMaxClauseCount((int)maxClausesCount);
        this.getLuceneCorruptionChecker().checkAndFixIndexes(allIndexPaths);
    }

    private void checkUntranslatedKeyFixer() {
        Optional untranslatedKeyFixer = ComponentAccessor.getComponentSafely(UntranslatedKeyFixer.class);
        if (untranslatedKeyFixer.isPresent()) {
            log.debug("Running untranslated key fixer...");
            ((UntranslatedKeyFixer)untranslatedKeyFixer.get()).runOnce();
        } else {
            log.warn("Could not run untranslated key fixer.");
        }
    }

    private void checkLanguageExists() {
        ApplicationProperties ap = ComponentAccessor.getApplicationProperties();
        if (ap.getString("jira.i18n.language.index") == null) {
            log.info("Input Language has not been set.  Setting to 'English - Moderate Stemming'");
            ap.setString("jira.i18n.language.index", "english-moderate-stemming");
        }
    }

    private void addJohnsonEvent(Event event) {
        JiraJohnsonContainer eventCont = this.johnsonProvider.getContainer();
        eventCont.addEvent(event);
    }

    private void checkMailListenerAndService() throws Exception {
        this.ensureSingleListener(MailListener.class, "Mail Listener");
        this.ensureSingleService("com.atlassian.jira.service.services.mail.MailQueueService", "Mail Queue Service");
    }

    private void checkIssueAssignHistoryListener() throws Exception {
        this.ensureSingleListener(IssueAssignHistoryListener.class, "Issue Assignment Listener");
    }

    private void checkIndexingSetup() throws Exception {
        String indexPath = ComponentAccessor.getIndexPathManager().getIndexRootPath();
        if (!this.directoryExists(indexPath)) {
            log.error("Indexing is turned on, but index path [" + indexPath + "] invalid - disabling indexing");
            this.removeListenersOfType(IssueIndexListener.class);
            ((IndexingConfiguration)ComponentAccessor.getComponent(IndexingConfiguration.class)).disableIndex();
            if (JiraUtils.isSetUp()) {
                Event event = new Event(EventType.get((String)"reindex"), "The Jira search index is missing.", EventLevel.get((String)"warning"));
                this.addJohnsonEvent(event);
            }
            return;
        }
        this.ensureSingleListener(IssueIndexListener.class, "Issue Index Listener");
    }

    private boolean directoryExists(String path) {
        File dir;
        return path != null && (dir = new File(path)).exists() && dir.isDirectory();
    }

    private void ensureSingleListener(Class<? extends JiraListener> clazz, String name) throws Exception {
        String classname = clazz.getName();
        List listenerConfigs = ComponentAccessor.getOfBizDelegator().findAll("ListenerConfig");
        boolean foundOne = false;
        ArrayList toRemove = Lists.newArrayListWithCapacity((int)listenerConfigs.size());
        for (Object element : listenerConfigs) {
            GenericValue listenerConfig = (GenericValue)element;
            if (!listenerConfig.getString("clazz").equals(classname)) continue;
            if (foundOne) {
                toRemove.add(listenerConfig);
                continue;
            }
            foundOne = true;
        }
        if (!foundOne) {
            if ("true".equals(ComponentAccessor.getApplicationProperties().getString("jira.setup"))) {
                log.error("Could not find " + name + ", adding.");
            } else {
                log.info("Could not find " + name + ", adding.");
            }
            ListenerManager listenerManager = (ListenerManager)ComponentAccessor.getComponent(ListenerManager.class);
            try {
                listenerManager.createListener(name, clazz);
            }
            catch (Exception e) {
                log.error("Error adding listener: " + e, (Throwable)e);
            }
        } else if (toRemove.size() > 0) {
            log.debug("Removing " + toRemove.size() + " extra listeners with class " + classname);
            ComponentAccessor.getOfBizDelegator().removeAll((List)toRemove);
            ComponentAccessor.getListenerManager().refresh();
        }
    }

    private void ensureSingleService(String clazz, String name) throws Exception {
        Collection<JiraServiceContainer> serviceConfigs = this.getServices();
        boolean foundOne = false;
        ArrayList<JiraServiceContainer> toRemove = new ArrayList<JiraServiceContainer>();
        for (JiraServiceContainer jiraServiceContainer : serviceConfigs) {
            if (!jiraServiceContainer.getServiceClass().equals(clazz)) continue;
            if (foundOne) {
                toRemove.add(jiraServiceContainer);
                continue;
            }
            foundOne = true;
        }
        if (!foundOne) {
            if ("true".equals(ComponentAccessor.getApplicationProperties().getString("jira.setup"))) {
                log.error("Could not find " + name + ", adding.");
            } else {
                log.info("Could not find " + name + ", adding.");
            }
            try {
                ComponentAccessor.getServiceManager().addService(name, clazz, "0 * * * * ?");
            }
            catch (Exception e) {
                log.error("Error adding service: " + e, (Throwable)e);
            }
        } else if (!toRemove.isEmpty()) {
            log.debug("Removing " + toRemove.size() + " extra services with class " + clazz);
            for (Object object : toRemove) {
                JiraServiceContainer serviceContainer = (JiraServiceContainer)object;
                ComponentAccessor.getServiceManager().removeService(serviceContainer.getId());
            }
        }
    }

    private void setStartupTime(@Nullable ServletContext context) {
        if (context != null) {
            context.setAttribute("jira_startup_time", (Object)System.currentTimeMillis());
        }
    }

    private void removeListenersOfType(Class<? extends JiraListener> listenerClass) {
        ((ListenerManager)ComponentAccessor.getComponent(ListenerManager.class)).deleteListener(listenerClass);
    }

    private void logServerId() {
        String serverId = ((JiraLicenseService)ComponentAccessor.getComponentOfType(JiraLicenseService.class)).getServerId();
        log.info("The Server ID for this JIRA instance is: [{}]", (Object)serverId);
    }
}

