/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.event.JiraUpgradedEvent;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.license.BuildVersionLicenseCheck;
import com.atlassian.jira.license.LicenseCheck;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.UpgradeIndexManager;
import com.atlassian.jira.upgrade.UpgradeResult;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryManager;
import com.atlassian.jira.upgrade.util.BuildNumberDao;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.core.UpgradeTaskManager;
import com.atlassian.upgrade.core.dao.UpgradeTaskHistoryDao;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseCheckingUpgradeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseCheckingUpgradeService.class);
    private static final String RUNNING_UPGRADES_CALLABLE_EXCEPTION_ERROR = "There was an exception thrown when trying to complete the upgrades";
    private static final String REINDEX_FAILURE = "There was a failure when running the reindex";
    private static final String UPGRADE_FRAMEWORK_FAILED_UPGRADE_ERROR = "The upgrade task manager has returned a non-successful result from running the upgrades";
    private final UpgradeTaskHistoryDao upgradeTaskHistoryDao;
    private final UpgradeTaskManager upgradeTaskManager;
    private final BuildNumberDao buildNumberDao;
    private final BuildUtilsInfo buildUtilsInfo;
    private final UpgradeVersionHistoryManager upgradeVersionHistoryManager;
    private final UpgradeIndexManager upgradeIndexManager;
    private final JiraLicenseService jiraLicenseService;
    private final BuildVersionLicenseCheck buildVersionLicenseCheck;
    private final I18nHelper.BeanFactory i18nHelperFactory;
    private final EventPublisher eventPublisher;
    private final OfBizDelegator ofBizDelegator;

    public LicenseCheckingUpgradeService(UpgradeTaskHistoryDao upgradeTaskHistoryDao, UpgradeTaskManager upgradeTaskManager, BuildNumberDao buildNumberDao, BuildUtilsInfo buildUtilsInfo, UpgradeVersionHistoryManager upgradeVersionHistoryManager, UpgradeIndexManager upgradeIndexManager, JiraLicenseService jiraLicenseService, BuildVersionLicenseCheck buildVersionLicenseCheck, I18nHelper.BeanFactory i18nHelperFactory, EventPublisher eventPublisher, OfBizDelegator ofBizDelegator) {
        this.upgradeTaskHistoryDao = upgradeTaskHistoryDao;
        this.upgradeTaskManager = upgradeTaskManager;
        this.buildNumberDao = buildNumberDao;
        this.buildUtilsInfo = buildUtilsInfo;
        this.upgradeVersionHistoryManager = upgradeVersionHistoryManager;
        this.upgradeIndexManager = upgradeIndexManager;
        this.jiraLicenseService = jiraLicenseService;
        this.buildVersionLicenseCheck = buildVersionLicenseCheck;
        this.i18nHelperFactory = i18nHelperFactory;
        this.eventPublisher = eventPublisher;
        this.ofBizDelegator = ofBizDelegator;
    }

    public UpgradeResult runUpgrades(Set<ReindexRequestType> reindexRequestTypes, UpgradeContext upgradeContext) {
        UpgradeResult upgradeResult;
        if (this.jiraLicenseService.isLicenseSet()) {
            LicenseCheck.Result licenseCheckResult = this.buildVersionLicenseCheck.evaluate();
            if (!licenseCheckResult.isPass()) {
                LOGGER.error("Cannot proceed with upgrades. License not valid");
                return new UpgradeResult(licenseCheckResult.getFailureMessage());
            }
            I18nHelper licenseValidationLocale = this.i18nHelperFactory.getInstance(Locale.ENGLISH);
            UpgradeResult validationResult = this.deriveStatus(this.jiraLicenseService.validate(licenseValidationLocale));
            if (!validationResult.successful()) {
                LOGGER.error("The current licenses are incompatible with this installation of JIRA.");
                return validationResult;
            }
        }
        if ((upgradeResult = this.executeUpgrades(reindexRequestTypes, upgradeContext)).successful()) {
            this.eventPublisher.publish((Object)new JiraUpgradedEvent(false));
        }
        return upgradeResult;
    }

    private UpgradeResult deriveStatus(Iterable<JiraLicenseService.ValidationResult> validationResults) {
        ArrayList<String> errors = new ArrayList<String>();
        for (JiraLicenseService.ValidationResult result : validationResults) {
            ErrorCollection errorCollection = result.getErrorCollection();
            errors.addAll(errorCollection.getErrorMessages());
            for (Map.Entry entry : errorCollection.getErrors().entrySet()) {
                LicenseDetails license = result.getLicenseDetails();
                if (license != null) {
                    errors.add(String.format("%s for %s : %s", entry.getKey(), license.getApplicationDescription(), entry.getValue()));
                    continue;
                }
                errors.add((String)entry.getKey() + " : " + (String)entry.getValue());
            }
        }
        return new UpgradeResult(errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpgradeResult executeUpgrades(Set<ReindexRequestType> reindexRequestTypes, UpgradeContext upgradeContext) {
        UpgradeResult result = new UpgradeResult();
        try {
            int oldHostBuildNumber = this.upgradeTaskHistoryDao.getDatabaseBuildNumber("host");
            boolean upgradesSuccessful = this.upgradeTaskManager.upgradeHostApp(upgradeContext);
            int newHostBuildNumber = this.upgradeTaskHistoryDao.getDatabaseBuildNumber("host");
            if (upgradesSuccessful) {
                boolean foregroundReindexFailed;
                boolean someHostUpgradesWereRun;
                this.buildNumberDao.setDatabaseBuildNumber(this.buildUtilsInfo.getCurrentBuildNumber());
                boolean bl = someHostUpgradesWereRun = oldHostBuildNumber != newHostBuildNumber;
                if (someHostUpgradesWereRun) {
                    this.upgradeVersionHistoryManager.addUpgradeVersionHistory(newHostBuildNumber, this.buildUtilsInfo.getVersion());
                    this.logUpgradedToVersion(newHostBuildNumber);
                }
                boolean bl2 = foregroundReindexFailed = !this.upgradeIndexManager.runReindexIfNeededAndAllowed(reindexRequestTypes);
                if (foregroundReindexFailed) {
                    LOGGER.error("There was an error trying to complete the re-index after an upgrade");
                    result.addError(REINDEX_FAILURE);
                }
            } else {
                this.buildNumberDao.setDatabaseBuildNumber(String.valueOf(newHostBuildNumber));
                LOGGER.error("There was an error running the upgrades");
                result.addError(UPGRADE_FRAMEWORK_FAILED_UPGRADE_ERROR);
            }
            this.buildNumberDao.setJiraVersion(this.buildUtilsInfo.getVersion());
            this.buildNumberDao.setMinimumDowngradeVersion();
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred when running to call a callable method, this shouldn't happen.", (Throwable)e);
            result.addError(RUNNING_UPGRADES_CALLABLE_EXCEPTION_ERROR);
        }
        finally {
            this.ofBizDelegator.refreshSequencer();
        }
        return result;
    }

    private void logUpgradedToVersion(int newBuildNumber) {
        String msg = "\n\n*******************************************************************\n Upgrade Succeeded! JIRA has been upgraded to build number " + newBuildNumber + '\n' + "*******************************************************************\n";
        LOGGER.info(msg);
    }
}

