/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QAction;
import com.atlassian.jira.model.querydsl.QCommentVersion;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.model.querydsl.QIssueVersion;
import com.atlassian.jira.model.querydsl.QWorklog;
import com.atlassian.jira.model.querydsl.QWorklogVersion;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import com.atlassian.jira.upgrade.tasks.util.Monitoring;
import com.google.common.base.Stopwatch;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build900000
extends AbstractImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build900000.class);
    private static final String ISSUE = "issue";
    private static final String COMMENT = "comment";
    private static final String WORKLOG = "worklog";
    private static final Duration WATCHDOG_MESSAGE_INTERVAL = Duration.ofSeconds(30L);
    private final QueryDslAccessor queryDslAccessor;
    private final QIssueVersion issueVersion = QIssueVersion.ISSUE_VERSION;
    private final QCommentVersion commentVersion = QCommentVersion.COMMENT_VERSION;
    private final QWorklogVersion worklogVersion = QWorklogVersion.WORKLOG_VERSION;
    private final QWorklog worklog = QWorklog.WORKLOG;
    private final QIssue issue = QIssue.ISSUE;
    private final QAction action = QAction.ACTION;
    private final Expression<?> artificialInsertMarker = Expressions.constant((Object)new Timestamp(0L));
    private final Expression<?>[] issueColumns;
    private final Expression<?>[] commentsColumns;
    private final Expression<?>[] worklogColumns;
    private final Path<?>[] issueVersionColumnsOrder;
    private final Path<?>[] commentVersionColumnsOrder;
    private final Path<?>[] worklogVersionColumnsOrder;

    public UpgradeTask_Build900000(QueryDslAccessor queryDslAccessor) {
        this.issueColumns = new Expression[]{this.issue.id, Expressions.nullExpression(), this.artificialInsertMarker, Expressions.constant((Object)1L), Expressions.constant((Object)Character.valueOf('N'))};
        this.commentsColumns = new Expression[]{this.action.id, this.action.issue, this.artificialInsertMarker, Expressions.constant((Object)1L), Expressions.constant((Object)Character.valueOf('N'))};
        this.worklogColumns = new Expression[]{this.worklog.id, this.worklog.issue, this.artificialInsertMarker, Expressions.constant((Object)1L), Expressions.constant((Object)Character.valueOf('N'))};
        this.issueVersionColumnsOrder = new Path[]{this.issueVersion.issueId, this.issueVersion.parentIssueId, this.issueVersion.updateTime, this.issueVersion.indexVersion, this.issueVersion.deleted};
        this.commentVersionColumnsOrder = new Path[]{this.commentVersion.commentId, this.commentVersion.parentIssueId, this.commentVersion.updateTime, this.commentVersion.indexVersion, this.commentVersion.deleted};
        this.worklogVersionColumnsOrder = new Path[]{this.worklogVersion.worklogId, this.worklogVersion.parentIssueId, this.worklogVersion.updateTime, this.worklogVersion.indexVersion, this.worklogVersion.deleted};
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    public int getBuildNumber() {
        return 900000;
    }

    @Override
    public String getShortDescription() {
        return "Adds index versions to issue, worklog and comment version tables.";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }

    long countVersionsToAdd(Expression entityTable, @Nullable Predicate entityTableFilter, Expression entityVersionTable) {
        long countEntity = this.queryDslAccessor.executeQuery(connection -> {
            SQLQuery sqlQuery = (SQLQuery)connection.newSqlQuery().select(Expressions.constant((Object)1)).from(entityTable);
            if (entityTableFilter != null) {
                return ((SQLQuery)sqlQuery.where(entityTableFilter)).fetchCount();
            }
            return sqlQuery.fetchCount();
        });
        long countEntityVersions = this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)connection.newSqlQuery().select(Expressions.constant((Object)1)).from(entityVersionTable)).fetchCount());
        return countEntity - countEntityVersions;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        log.info("Running upgrade task that adds index versions to issue, worklog and comment version tables.");
        long countIssues = this.countVersionsToAdd((Expression)this.issue, null, (Expression)this.issueVersion);
        long countComments = this.countVersionsToAdd((Expression)this.action, (Predicate)this.action.type.eq((Object)COMMENT), (Expression)this.commentVersion);
        long countWorklogs = this.countVersionsToAdd((Expression)this.worklog, null, (Expression)this.worklogVersion);
        log.info("Adding {} issue versions, {} comments versions and {} worklog versions.", new Object[]{countIssues, countComments, countWorklogs});
        if (countIssues > 0L) {
            this.runMeasured(this::populateIssueVersion, ISSUE);
        }
        if (countComments > 0L) {
            this.runMeasured(this::populateCommentVersion, COMMENT);
        }
        if (countWorklogs > 0L) {
            this.runMeasured(this::populateWorklogVersion, WORKLOG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMeasured(Runnable populateEntityVersions, String entityName) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Thread watchdogThread = Monitoring.startWatchdogThreadForCurrentThread("upgrade-watchdog", WATCHDOG_MESSAGE_INTERVAL, log, String.format("[UPGRADE WATCH] Still inserting %s versions.", entityName));
        try {
            populateEntityVersions.run();
        }
        finally {
            watchdogThread.interrupt();
        }
        long elapsedSeconds = stopwatch.elapsed(TimeUnit.SECONDS);
        log.info("It took {} seconds to create {} versions. ", (Object)elapsedSeconds, (Object)entityName);
    }

    private void populateIssueVersion() {
        log.info("Start inserting issue versions.");
        long insertedIssues = this.queryDslAccessor.withNewConnection().executeQuery(connection -> {
            connection.setAutoCommit(true);
            return connection.insert(this.issueVersion).columns((Path[])this.issueVersionColumnsOrder).select((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(this.issueColumns).from((Expression)this.issue)).leftJoin((EntityPath)this.issueVersion)).on((Predicate)this.issueVersion.issueId.eq(this.issue.id))).where((Predicate)this.issueVersion.issueId.isNull())).execute();
        });
        log.info("Inserted {} issue versions. ", (Object)insertedIssues);
    }

    private void populateCommentVersion() {
        log.info("Start inserting comment versions.");
        long insertedComments = this.queryDslAccessor.withNewConnection().executeQuery(connection -> {
            connection.setAutoCommit(true);
            return connection.insert(this.commentVersion).columns((Path[])this.commentVersionColumnsOrder).select((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(this.commentsColumns).from((Expression)this.action)).leftJoin((EntityPath)this.commentVersion)).on((Predicate)this.commentVersion.commentId.eq(this.action.id))).where((Predicate)this.commentVersion.commentId.isNull().and((Predicate)this.action.type.eq((Object)COMMENT)))).execute();
        });
        log.info("Inserted {} comment versions.", (Object)insertedComments);
    }

    private void populateWorklogVersion() {
        log.info("Start inserting worklog versions.");
        long insertedWorklogs = this.queryDslAccessor.withNewConnection().executeQuery(connection -> {
            connection.setAutoCommit(true);
            return connection.insert(this.worklogVersion).columns((Path[])this.worklogVersionColumnsOrder).select((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(this.worklogColumns).from((Expression)this.worklog)).leftJoin((EntityPath)this.worklogVersion)).on((Predicate)this.worklogVersion.worklogId.eq(this.worklog.id))).where((Predicate)this.worklogVersion.worklogId.isNull())).execute();
        });
        log.info("Inserted {} worklog versions.", (Object)insertedWorklogs);
    }
}

