/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.JiraRelationalPathBase;
import com.atlassian.jira.model.querydsl.QOSPropertyDate;
import com.atlassian.jira.model.querydsl.QOSPropertyDecimal;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyNumber;
import com.atlassian.jira.model.querydsl.QOSPropertyString;
import com.atlassian.jira.model.querydsl.QOSPropertyText;
import com.atlassian.jira.upgrade.AbstractDelayableUpgradeTask;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build9150000
extends AbstractDelayableUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build9150000.class);
    private static final List<JiraRelationalPathBase<?>> PROPERTY_VALUE_PATH_BASES = Arrays.asList(new JiraRelationalPathBase[]{QOSPropertyDate.O_S_PROPERTY_DATE, QOSPropertyDecimal.O_S_PROPERTY_DECIMAL, QOSPropertyNumber.O_S_PROPERTY_NUMBER, QOSPropertyString.O_S_PROPERTY_STRING, QOSPropertyText.O_S_PROPERTY_TEXT});
    private final DelegatorInterface delegatorInterface;
    private final QueryDslAccessor queryDslAccessor;

    public UpgradeTask_Build9150000(DelegatorInterface delegatorInterface, QueryDslAccessor queryDslAccessor) {
        this.delegatorInterface = delegatorInterface;
        this.queryDslAccessor = queryDslAccessor;
    }

    @Override
    public int getBuildNumber() {
        return 9150000;
    }

    @Override
    public String getShortDescription() {
        return "Adds a unique constraint to propertyentry table after making sure the table is properly de-duplicated.";
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return true;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        AtomicLong deletedEntries = new AtomicLong();
        AtomicLong deletedValues = new AtomicLong();
        this.queryDslAccessor.withNewConnection().execute(conn -> {
            conn.setAutoCommit(false);
            QOSPropertyEntry preload = new QOSPropertyEntry("preload");
            SQLQuery preloadQuery = (SQLQuery)SQLExpressions.select((Expression[])new Expression[]{preload.id, preload.entityId, preload.entityName, preload.propertyKey}).from((Expression)preload);
            SQLQuery latestIdByEntityNameEntityIdPropertyKeyQuery = (SQLQuery)((SQLQuery)SQLExpressions.select((Expression)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.max()).from((SubQueryExpression)preloadQuery, (Path)QOSPropertyEntry.O_S_PROPERTY_ENTRY)).groupBy(new Expression[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName, QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId, QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey});
            deletedValues.set(PROPERTY_VALUE_PATH_BASES.stream().mapToLong(pathBase -> conn.delete((RelationalPath<?>)pathBase).where((Predicate)pathBase.getNumericIdPath().notIn((SubQueryExpression)latestIdByEntityNameEntityIdPropertyKeyQuery)).execute()).sum());
            deletedEntries.set(conn.delete((RelationalPath<?>)QOSPropertyEntry.O_S_PROPERTY_ENTRY).where((Predicate)QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.notIn((SubQueryExpression)latestIdByEntityNameEntityIdPropertyKeyQuery)).execute());
            conn.commit();
        });
        if (deletedEntries.get() > 0L) {
            LOG.info("Deleted {} stale property set entries that were duplicates of the latest entry for each (entityName, entityId, propertyKey) tuple.", (Object)deletedEntries.get());
        }
        if (deletedValues.get() > 0L) {
            LOG.info("Deleted {} stale property set values that were duplicates of the latest entry for each (entityName, entityId, propertyKey) tuple.", (Object)deletedValues.get());
        }
        String entityName = QOSPropertyEntry.O_S_PROPERTY_ENTRY.getEntityName();
        String helperName = this.delegatorInterface.getEntityHelper(entityName).getHelperName();
        DatabaseUtil dbUtil = new DatabaseUtil(helperName);
        ModelEntity modelEntity = this.delegatorInterface.getModelEntity(entityName);
        ModelIndex index = modelEntity.getIndex("osproperty_entId_name_propKey");
        dbUtil.deleteDeclaredIndex(modelEntity, index);
        dbUtil.createDeclaredIndex(modelEntity, index);
    }
}

