/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.InternalProjectPermissionHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultUserProjectHistoryManager
implements UserProjectHistoryManager {
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final UserHistoryManager userHistoryManager;
    private final InternalProjectPermissionHelper projectPermissionHelper;

    public DefaultUserProjectHistoryManager(UserHistoryManager userHistoryManager, ProjectManager projectManager, PermissionManager permissionManager, InternalProjectPermissionHelper projectPermissionHelper) {
        this.userHistoryManager = userHistoryManager;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.projectPermissionHelper = projectPermissionHelper;
    }

    public void addProjectToHistory(ApplicationUser user, Project project) {
        Assertions.notNull((String)"project", (Object)project);
        this.userHistoryManager.addItemToHistory(UserHistoryItem.PROJECT, user, project.getId().toString());
    }

    public boolean hasProjectHistory(int permission, ApplicationUser user) {
        List history = this.userHistoryManager.getHistory(UserHistoryItem.PROJECT, user);
        if (history != null) {
            for (UserHistoryItem historyItem : history) {
                Project project = this.projectManager.getProjectObj(Long.valueOf(historyItem.getEntityId()));
                if (project == null || !this.projectPermissionHelper.hasPermission(new ProjectPermissionKey(permission), project, user)) continue;
                return true;
            }
        }
        return false;
    }

    public Project getCurrentProject(int permission, ApplicationUser user) {
        List history = this.userHistoryManager.getHistory(UserHistoryItem.PROJECT, user);
        if (history != null) {
            for (UserHistoryItem historyItem : history) {
                Project project = this.projectManager.getProjectObj(Long.valueOf(historyItem.getEntityId()));
                if (project == null || !this.projectPermissionHelper.hasPermission(new ProjectPermissionKey(permission), project, user) || project.isArchived()) continue;
                return project;
            }
        }
        return null;
    }

    public List<UserHistoryItem> getProjectHistoryWithoutPermissionChecks(ApplicationUser user) {
        return this.userHistoryManager.getHistory(UserHistoryItem.PROJECT, user);
    }

    public List<Project> getProjectHistoryWithPermissionChecks(int permission, ApplicationUser user) {
        return this.getProjectHistoryWithPermissionChecks(user, (Function<Project, Boolean>)((Function)project -> this.projectPermissionHelper.hasPermission(new ProjectPermissionKey(permission), (Project)project, user)));
    }

    public List<Project> getProjectHistoryWithPermissionChecks(ProjectAction projectAction, ApplicationUser user) {
        return this.getProjectHistoryWithPermissionChecks(user, (Function<Project, Boolean>)((Function)project -> projectAction.hasPermission(this.permissionManager, user, project)));
    }

    private List<Project> getProjectHistoryWithPermissionChecks(ApplicationUser user, Function<Project, Boolean> permissionCheck) {
        List<UserHistoryItem> history = this.getProjectHistoryWithoutPermissionChecks(user);
        if (history != null) {
            ArrayList<Project> returnList = new ArrayList<Project>();
            for (UserHistoryItem userHistoryItem : history) {
                Project project = this.projectManager.getProjectObj(Long.valueOf(userHistoryItem.getEntityId()));
                if (project == null || project.isArchived() || !((Boolean)permissionCheck.apply((Object)project)).booleanValue()) continue;
                returnList.add(project);
            }
            return returnList;
        }
        return Collections.emptyList();
    }
}

