/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationPrevalidateEvent;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.AnonymizationParameters;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.BusinessLogicValidationResult;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.user.anonymize.UserState;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationStep;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationSteps;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnonymizeUserService
implements AnonymizeUserService {
    private static final Logger log = LoggerFactory.getLogger(DefaultAnonymizeUserService.class);
    private final UserManager userManager;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final GlobalPermissionManager globalPermissionManager;
    private final UserKeyStore userKeyStore;
    private final ExtendedUserDao ofBizUserDao;
    private final AnonymizeOperationSteps anonymizeOperationSteps;
    private final EventPublisher eventPublisher;
    private final ReindexMessageManager reindexMessageManager;

    public DefaultAnonymizeUserService(UserManager userManager, I18nHelper.BeanFactory i18nBeanFactory, GlobalPermissionManager globalPermissionManager, UserKeyStore userKeyStore, ExtendedUserDao extendedUserDao, AnonymizeOperationSteps anonymizeOperationSteps, EventPublisher eventPublisher, ReindexMessageManager reindexMessageManager) {
        this.userManager = userManager;
        this.i18nBeanFactory = i18nBeanFactory;
        this.globalPermissionManager = globalPermissionManager;
        this.userKeyStore = userKeyStore;
        this.ofBizUserDao = extendedUserDao;
        this.anonymizeOperationSteps = anonymizeOperationSteps;
        this.eventPublisher = eventPublisher;
        this.reindexMessageManager = reindexMessageManager;
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizeValidationResult preValidateAnonymize(@Nonnull AnonymizationParameters request) {
        log.debug("Publishing userAnonymizationPrevalidateEvent");
        this.eventPublisher.publish((Object)new UserAnonymizationPrevalidateEvent(request.getUserKey()));
        log.debug("Published userAnonymizationPrevalidateEvent");
        return this.validate(request, true);
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizeValidationResult validateAnonymize(@Nonnull AnonymizationParameters request) {
        return this.validate(request, false);
    }

    private AnonymizeUserService.AnonymizeValidationResult validate(AnonymizationParameters anonymizationParameters, boolean preValidate) {
        BusinessLogicValidationResult validationResult;
        Optional<ApplicationUserEntity> existingAppUser;
        UserManager.UserState crowdUserState;
        SimpleErrorCollection errors = new SimpleErrorCollection();
        ApplicationUser executor = anonymizationParameters.getExecutor();
        I18nHelper i18nBean = this.i18nBeanFactory.getInstance(executor);
        AnonymizeUserService.OperationsReport<Void> validationReport = new AnonymizeUserService.OperationsReport<Void>();
        if (!this.isAdministrator(executor)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.no.permission"));
            return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, anonymizationParameters, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
        }
        String originalUserKey = anonymizationParameters.getUserKey();
        ApplicationUser userToUpdate = this.userManager.getUserByKeyEvenWhenUnknown(originalUserKey);
        if (!this.isSysAdmin(executor) && this.isSysAdmin(userToUpdate)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.must.be.sysadmin.to.edit.sysadmin"));
            return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, anonymizationParameters, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
        }
        if (executor.getKey().equals(anonymizationParameters.getUserKey())) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.yourself"));
            return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, anonymizationParameters, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
        }
        AnonymizeUserService.AnonymizeProcessData.Builder dataBuilder = AnonymizeUserService.AnonymizeProcessData.newBuilder(anonymizationParameters);
        dataBuilder.user(userToUpdate);
        UserState userState = dataBuilder.build().getUserState();
        if (userState == UserState.NOT_FOUND) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.user.does.not.exist", originalUserKey));
            return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, anonymizationParameters, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
        }
        if (userState == UserState.PRESENT && (crowdUserState = this.userManager.getUserState(userToUpdate)).isInMultipleDirectories()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.multiple.directories"));
            return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, anonymizationParameters, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
        }
        boolean userKeyAlreadyAnonymized = this.userKeyStore.isSystemKey(userToUpdate.getKey());
        boolean userUsernameAlreadyAnonymized = this.userKeyStore.isSystemKey(userToUpdate.getUsername());
        if (!userKeyAlreadyAnonymized) {
            if (this.isRerunWithUserKeyDifferentThanCurrent(anonymizationParameters, userToUpdate)) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.rerun.current.userkey.not.anonymized", anonymizationParameters.getOldUserKey()));
                return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, anonymizationParameters, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
            }
            Optional<String> anonymizedKeyOption = this.getUniqueAnonymizedKey(userToUpdate);
            if (!anonymizedKeyOption.isPresent()) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.cant.generate.userkey", originalUserKey));
                return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, anonymizationParameters, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
            }
            String anonymizedKey = anonymizedKeyOption.get();
            dataBuilder.newUserKey(anonymizedKey);
            log.info("User key is not anonymized ({}), should anonymize to ({})", (Object)originalUserKey, (Object)anonymizedKey);
        } else if (this.isRerunWithUserKeyDifferentThanCurrent(anonymizationParameters, userToUpdate)) {
            existingAppUser = this.userKeyStore.getUserForKey(anonymizationParameters.getOldUserKey());
            if (existingAppUser.isPresent()) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.rerun.old.userkey.existing.user", anonymizationParameters.getOldUserKey()));
                return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, anonymizationParameters, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
            }
        } else {
            log.info("User key is already anonymized ({}), no need to change it", (Object)userToUpdate.getKey());
        }
        if (!userUsernameAlreadyAnonymized) {
            if (this.isRerunWithUsernameDifferentThanCurrent(anonymizationParameters, userToUpdate)) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.rerun.current.username.not.anonymized", anonymizationParameters.getOldUserName()));
                return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, anonymizationParameters, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
            }
            Optional<String> anonymizedUsernameOption = this.userKeyStore.getUniqueUsernameFromId(userToUpdate.getId());
            if (!anonymizedUsernameOption.isPresent()) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.cant.generate.username", userToUpdate.getUsername()));
                return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, anonymizationParameters, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
            }
            String anonymizedUsername = anonymizedUsernameOption.get();
            log.info("Username is not anonymized ({}), should rename to ({})", (Object)userToUpdate.getUsername(), (Object)anonymizedUsername);
            dataBuilder.newUserName(anonymizedUsername);
        } else if (this.isRerunWithUsernameDifferentThanCurrent(anonymizationParameters, userToUpdate)) {
            existingAppUser = this.userKeyStore.getUserForUsername(anonymizationParameters.getOldUserName());
            if (existingAppUser.isPresent()) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.rerun.old.username.existing.user", anonymizationParameters.getOldUserName()));
                return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, anonymizationParameters, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
            }
        } else {
            log.info("Username is already anonymized ({}), no need to change it", (Object)userToUpdate.getName());
        }
        if (!preValidate && !(validationResult = this.validateBusinessLogic(anonymizationParameters)).isValid()) {
            return AnonymizeUserService.AnonymizeValidationResult.fromFailedBusinessLogicValidation(anonymizationParameters, validationResult);
        }
        dataBuilder.userDeletedExternally(this.ofBizUserDao.isDeletedExternally(userToUpdate.getDirectoryId(), userToUpdate.getUsername()));
        dataBuilder.userDeleted(this.userManager.isUserDeleted(userToUpdate));
        dataBuilder.userKeyAlreadyAnonymized(userKeyAlreadyAnonymized);
        dataBuilder.userNameAlreadyAnonymized(userUsernameAlreadyAnonymized);
        AnonymizeUserService.AnonymizeProcessData anonymizationData = dataBuilder.build();
        AnonymizeUserService.OperationsReport<Collection<AffectedEntity>> affectedEntitiesOutcome = this.getAffectedEntities(anonymizationData);
        if (!affectedEntitiesOutcome.isValid()) {
            return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, anonymizationParameters, null, affectedEntitiesOutcome, validationReport);
        }
        dataBuilder.affectedEntities(this.getAffectedEntities(affectedEntitiesOutcome));
        boolean affectedEntitiesHandlerWithError = this.isAffectedEntitiesHandlerWithError(affectedEntitiesOutcome);
        dataBuilder.affectedEntitiesWithHandlerError(affectedEntitiesHandlerWithError);
        AnonymizeUserService.AnonymizeProcessData data = dataBuilder.build();
        Collection<AnonymizeUserService.AnonymizeOperation> operationsToPerform = data.getOperationsWeWouldLikeToPerform(preValidate);
        for (AnonymizeUserService.AnonymizeOperation anonymizeOperation : operationsToPerform) {
            AnonymizeOperationStep anonymizeOperationStep = this.anonymizeOperationSteps.getStep(anonymizeOperation);
            if (anonymizeOperationStep == null) continue;
            ServiceResult operationValidationOutcome = anonymizeOperationStep.validate(data, i18nBean, preValidate);
            validationReport.putReport(new AnonymizeUserService.SingleOperationReport<Object>(anonymizeOperationStep.getAnonymizeOperation(), new ServiceOutcomeWithWarnings<Object>(null, operationValidationOutcome.getErrorCollection(), new HashMap<String, ErrorCollection>())));
        }
        return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, anonymizationParameters, data, affectedEntitiesOutcome, validationReport);
    }

    private boolean isRerunWithUsernameDifferentThanCurrent(@Nonnull AnonymizationParameters request, @Nonnull ApplicationUser userToUpdate) {
        return request.isRerunPluginPoints() && StringUtils.isNotBlank((CharSequence)request.getOldUserName()) && !request.getOldUserName().equals(userToUpdate.getUsername());
    }

    private boolean isRerunWithUserKeyDifferentThanCurrent(@Nonnull AnonymizationParameters request, @Nonnull ApplicationUser userToUpdate) {
        return request.isRerunPluginPoints() && StringUtils.isNotBlank((CharSequence)request.getOldUserKey()) && !request.getOldUserKey().equals(userToUpdate.getKey());
    }

    private boolean affectedEntitiesContainAtLeastOneTransferOwnershipEntity(AnonymizeUserService.OperationsReport<Collection<AffectedEntity>> affectedEntitiesOutcome) {
        List<AffectedEntity> returnedFromHandlers = this.getAffectedEntities(affectedEntitiesOutcome);
        return returnedFromHandlers.stream().anyMatch(entity -> entity.getType() == AffectedEntityType.TRANSFER_OWNERSHIP);
    }

    private boolean isAffectedEntitiesHandlerWithError(AnonymizeUserService.OperationsReport<Collection<AffectedEntity>> affectedEntitiesOutcome) {
        return affectedEntitiesOutcome.getReports().stream().map(AnonymizeUserService.SingleOperationReport::getResult).map(ServiceOutcomeWithWarnings::getWarnings).anyMatch(warnings -> !warnings.isEmpty());
    }

    private List<AffectedEntity> getAffectedEntities(AnonymizeUserService.OperationsReport<Collection<AffectedEntity>> affectedEntitiesOutcome) {
        return affectedEntitiesOutcome.getReports().stream().map(AnonymizeUserService.SingleOperationReport::getResult).map(ServiceOutcomeImpl::get).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private AnonymizeUserService.OperationsReport<Collection<AffectedEntity>> getAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationData) {
        AnonymizeUserService.OperationsReport<Collection<AffectedEntity>> operationsReport = new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>();
        if (!anonymizationData.getAnonymizationParameters().isGetAffectedEntities()) {
            return operationsReport;
        }
        Collection<AnonymizeUserService.AnonymizeOperation> operationsToPerform = anonymizationData.getOperationsWeWouldLikeToPerform(true);
        for (AnonymizeUserService.AnonymizeOperation operation : operationsToPerform) {
            AnonymizeOperationStep step = this.anonymizeOperationSteps.getStep(operation);
            if (step == null) continue;
            ServiceOutcomeWithWarnings<Collection<AffectedEntity>> affectedEntities = step.getAffectedEntities(anonymizationData);
            operationsReport.putReport(new AnonymizeUserService.SingleOperationReport<Collection<AffectedEntity>>(operation, affectedEntities));
        }
        return operationsReport;
    }

    private Optional<String> getUniqueAnonymizedKey(ApplicationUser userToUpdate) {
        return this.userKeyStore.getUniqueKeyFromId(userToUpdate.getId());
    }

    @Nonnull
    private BusinessLogicValidationResult validateBusinessLogic(@Nonnull AnonymizationParameters anonymizationParameters) {
        return this.anonymizeOperationSteps.getStepsForBusinessLogicValidation().stream().map(anonymizationStep -> anonymizationStep.validateBusinessLogic(anonymizationParameters)).reduce(BusinessLogicValidationResult.builder(), BusinessLogicValidationResult.Builder::addPartialResult, BusinessLogicValidationResult.Builder::merge).build();
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizePerformResult perform(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull Context asyncTaskContext) {
        Preconditions.checkArgument((boolean)validationResult.isValid());
        AnonymizationParameters validationRequest = validationResult.getRequest();
        log.debug("Publishing userAnonymizationStartedEvent");
        this.eventPublisher.publish((Object)validationResult.getProcessData().getUserAnonymizationStartedEvent());
        log.debug("Published userAnonymizationStartedEvent");
        AnonymizeUserService.OperationsReport<Void> anonymizeReport = new AnonymizeUserService.OperationsReport<Void>();
        AnonymizeUserService.AnonymizePerformResult anonymizePerformResult = new AnonymizeUserService.AnonymizePerformResult(validationRequest, validationResult.getProcessData(), anonymizeReport);
        for (AnonymizeOperationStep step2 : this.anonymizeOperationSteps.getStepsBlockingAnonymizationProcessOnFail()) {
            step2.performOperation(anonymizeReport, validationResult, asyncTaskContext).ifPresent(anonymizeReport::putReport);
            if (anonymizeReport.isValid()) continue;
            return anonymizePerformResult;
        }
        this.anonymizeOperationSteps.getStepsNotBlockingAnonymizationProcessOnFail().stream().map(step -> step.performOperation(anonymizeReport, validationResult, asyncTaskContext)).forEach(operationReport -> operationReport.ifPresent(anonymizeReport::putReport));
        log.debug("Publishing userAnonymizationFinishedEvent");
        this.eventPublisher.publish((Object)validationResult.getProcessData().getUserAnonymizationFinishedEvent());
        log.debug("Published userAnonymizationFinishedEvent");
        this.reindexMessageManager.pushRawMessage(validationRequest.getExecutor(), "admin.notification.user.anonymize.requires.reindex");
        return anonymizePerformResult;
    }

    @Override
    public int getStepCount(@Nonnull AnonymizeUserService.AnonymizeValidationResult anonymizeValidationResult) {
        if (!anonymizeValidationResult.isValid()) {
            return 0;
        }
        return Stream.concat(this.anonymizeOperationSteps.getStepsBlockingAnonymizationProcessOnFail().stream(), this.anonymizeOperationSteps.getStepsNotBlockingAnonymizationProcessOnFail().stream()).mapToInt(step -> step.getNumberOfTasks(anonymizeValidationResult)).sum();
    }

    private boolean isAdministrator(@Nullable ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private boolean isSysAdmin(@Nullable ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }
}

