/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.util.Supplier;
import io.atlassian.fugue.Either;
import java.util.function.Consumer;

@Internal
public class Retry<T> {
    private static NullReturn NULL = new NullReturn();
    private final Supplier<T> supplier;
    private final Consumer<Exception> exceptionHandler;
    private final Consumer<Exception> failureHandler;
    private final Consumer<Integer> successHandler;

    public static <T> Retry<T> from(Supplier<T> supplier) {
        return new Retry<T>(supplier, null, null, null);
    }

    public static Retry<NullReturn> from(Runnable runnable) {
        return Retry.from(() -> {
            runnable.run();
            return NULL;
        });
    }

    public Retry<T> onException(Consumer<Exception> exceptionHandler) {
        return new Retry<T>(this.supplier, exceptionHandler, this.failureHandler, this.successHandler);
    }

    public Retry<T> onFail(Consumer<Exception> failureHandler) {
        return new Retry<T>(this.supplier, this.exceptionHandler, failureHandler, this.successHandler);
    }

    public Retry<T> onSuccess(Consumer<Integer> successHandler) {
        return new Retry<T>(this.supplier, this.exceptionHandler, this.failureHandler, successHandler);
    }

    public Retry rethrowOnFail() {
        return new Retry<T>(this.supplier, this.exceptionHandler, e -> {
            throw new RuntimeException("Failed to retry on operation", (Throwable)e);
        }, this.successHandler);
    }

    private Retry(Supplier<T> supplier, Consumer<Exception> exceptionHandler, Consumer<Exception> failureHandler, Consumer<Integer> successHandler) {
        this.supplier = supplier;
        this.exceptionHandler = exceptionHandler;
        this.failureHandler = failureHandler;
        this.successHandler = successHandler;
    }

    public Either<Exception, T> executeOnce() {
        return this.executeTimes(0);
    }

    public Either<Exception, T> executeTimes(int times) {
        int attempt = 0;
        while (true) {
            try {
                Object result = this.supplier.get();
                if (this.successHandler != null) {
                    this.successHandler.accept(attempt);
                }
                return Either.right((Object)result);
            }
            catch (Exception e) {
                Exception last = e;
                if (this.exceptionHandler == null) continue;
                this.exceptionHandler.accept(e);
                if (++attempt <= times) continue;
                if (this.failureHandler != null) {
                    this.failureHandler.accept(last);
                }
                return Either.left((Object)last);
            }
            break;
        }
    }

    private static class NullReturn {
        private NullReturn() {
        }
    }
}

