/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.username.mention;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.util.streamingretrievers.BaseStreamingRetriever;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.handlers.username.mention.MentionAnonymizationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymizeMentionsCommand<E, S extends BaseStreamingRetriever<?, String, E>> {
    private static final Logger log = LoggerFactory.getLogger(AnonymizeMentionsCommand.class);
    public static final int BATCH_SIZE = 50;
    private final S streamingRetriever;
    private final Worker<E> worker;
    protected final QueryDslAccessor db;
    protected final JiraAuthenticationContext authContext;

    public AnonymizeMentionsCommand(S streamingRetriever, Worker<E> worker, QueryDslAccessor db, JiraAuthenticationContext authContext) {
        this.streamingRetriever = streamingRetriever;
        this.worker = worker;
        this.db = db;
        this.authContext = authContext;
    }

    public ServiceResult execute(UserPropertyChangeParameter changeParameter) {
        MentionAnonymizationContext ctx = new MentionAnonymizationContext(changeParameter);
        int updated = ((BaseStreamingRetriever)this.streamingRetriever).stream((String)ctx.mention, 50).mapToInt(actions -> {
            actions.forEach(action -> this.updateEntityInDatabase(action, ctx));
            return actions.size();
        }).sum();
        if (updated > 0) {
            this.worker.afterUpdates();
        }
        return new ServiceResultImpl(ctx.errors, ctx.warnings);
    }

    private void updateEntityInDatabase(E entity, MentionAnonymizationContext anonymizationCtx) {
        try {
            this.worker.executeUpdateEntityQuery(entity, this.db, anonymizationCtx);
        }
        catch (Exception ex) {
            log.error("Error during updating entity", (Throwable)ex);
            anonymizationCtx.errors.addErrorMessage(this.authContext.getI18nHelper().getText(this.worker.getSavingErrorMessageKey(), ex.getMessage()));
        }
    }

    public static interface Worker<E> {
        public void executeUpdateEntityQuery(E var1, QueryDslAccessor var2, MentionAnonymizationContext var3);

        public String getSavingErrorMessageKey();

        default public void afterUpdates() {
        }
    }
}

