/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CollectionReorderer {
    private CollectionReorderer() {
    }

    public static <T> void moveToStart(List<T> objects, T toMove) {
        CollectionReorderer.assertContains(objects, toMove);
        objects.remove(toMove);
        objects.add(0, toMove);
    }

    public static <T> void moveToEnd(List<T> objects, T toMove) {
        CollectionReorderer.assertContains(objects, toMove);
        objects.remove(toMove);
        objects.add(objects.size(), toMove);
    }

    public static <T> void decreasePosition(List<T> objects, T toMove) {
        CollectionReorderer.assertContains(objects, toMove);
        int initialPosition = objects.indexOf(toMove);
        if (initialPosition < 0 || initialPosition == objects.size() - 1) {
            return;
        }
        CollectionReorderer.moveToPosition(objects, initialPosition, initialPosition + 1);
    }

    public static <T> void increasePosition(List<T> objects, T toMove) {
        CollectionReorderer.assertContains(objects, toMove);
        int initialPosition = objects.indexOf(toMove);
        if (initialPosition < 1) {
            return;
        }
        CollectionReorderer.moveToPosition(objects, initialPosition, initialPosition - 1);
    }

    public static <T> void moveToPositionAfter(List<T> objects, T toMove, T target) {
        int targetPosition;
        CollectionReorderer.assertContains(objects, toMove);
        int initialPosition = objects.indexOf(toMove);
        if (target == null) {
            targetPosition = -1;
        } else {
            CollectionReorderer.assertContains(objects, target);
            targetPosition = objects.indexOf(target);
        }
        if (targetPosition < initialPosition) {
            ++targetPosition;
        }
        CollectionReorderer.moveToPosition(objects, initialPosition, targetPosition);
    }

    public static <T> void moveToPosition(List<T> objects, Map<Integer, T> positionToObjects) {
        for (T t : positionToObjects.values()) {
            objects.remove(t);
        }
        for (Map.Entry entry : positionToObjects.entrySet()) {
            objects.add((Integer)entry.getKey(), entry.getValue());
        }
    }

    public static <T> void moveToPosition(List<T> objects, int initialPosition, int targetPosition) {
        boolean outsideInitial;
        int objectsSize = objects.size();
        boolean outsideTarget = targetPosition < 0 || targetPosition >= objectsSize;
        boolean bl = outsideInitial = initialPosition < 0 || initialPosition >= objectsSize;
        if (!outsideTarget && !outsideInitial) {
            objects.add(targetPosition, objects.remove(initialPosition));
        }
    }

    private static <T> void assertContains(Collection<T> objects, T o) {
        if (!objects.contains(o)) {
            throw new IllegalArgumentException("Object " + o + " not contained in Collection " + objects);
        }
    }
}

