/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.log;

import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.log.Log4jKit;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import org.slf4j.LoggerFactory;

public class JiraLogLocator {
    private static final String AJL_APPENDER_NAME = "filelog";
    public static final String AJL_FILE_NAME = "atlassian-jira.log";
    private final FileStores fileStores;

    public JiraLogLocator(FileStores fileStores) {
        this.fileStores = (FileStores)Assertions.notNull((String)"fileStores", (Object)fileStores);
    }

    public File findJiraLogFile() {
        Collection<File> files = this.findAllJiraLogFiles();
        if (files.isEmpty()) {
            return null;
        }
        return files.iterator().next();
    }

    @Nonnull
    public Collection<File> findAllJiraLogFiles() {
        return JiraLogLocator.removeNonExistentFiles(this.findAllPotentialJiraLogFiles());
    }

    private Collection<File> findAllPotentialJiraLogFiles() {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        File logFile = this.findLogViaAppender();
        if (logFile != null) {
            files.add(logFile);
        }
        if ((logFile = this.findLogViaHome()) != null) {
            files.add(logFile);
        }
        files.add(this.findLogViaWorking());
        return files;
    }

    private File findLogViaWorking() {
        return new File(AJL_FILE_NAME).getAbsoluteFile();
    }

    private File findLogViaHome() {
        try {
            return this.fileStores.getLogPath().path(new String[]{AJL_FILE_NAME}).asJavaFile();
        }
        catch (IllegalStateException e) {
            LoggerFactory.getLogger(this.getClass()).debug("Unable to find log in JIRA home. Returning null.");
            return null;
        }
    }

    private File findLogViaAppender() {
        return Log4jKit.getLogFileName(AJL_APPENDER_NAME);
    }

    private static Collection<File> removeNonExistentFiles(Collection<File> files) {
        files.removeIf(file -> !file.exists() || !file.canRead());
        return files;
    }
}

