/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.versioning;

import com.atlassian.jira.cluster.ClusterSettings;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.versioning.EntityVersioningManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersioningCleanupService
implements JobRunner,
Startable {
    private static final Logger log = LoggerFactory.getLogger(VersioningCleanupService.class);
    static final String RETENTION_DAYS_PROPERTY_KEY = "jira.entity.version.cleanup.deleted.retention.days";
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)VersioningCleanupService.class.getName());
    static final JobId JOB_ID = JobId.of((String)VersioningCleanupService.class.getName());
    private final EntityVersioningManager entityVersioningManager;
    private final ApplicationProperties applicationProperties;
    private final SchedulerService schedulerService;
    private final Duration defaultRetentionPeriod;

    public VersioningCleanupService(EntityVersioningManager entityVersioningManager, ApplicationProperties applicationProperties, SchedulerService schedulerService) {
        this.entityVersioningManager = entityVersioningManager;
        this.applicationProperties = applicationProperties;
        this.schedulerService = schedulerService;
        this.defaultRetentionPeriod = ClusterSettings.getClusterRetentionPeriod();
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        Duration retentionPeriod = this.getRetentionPeriod();
        log.info("[VERSIONING] Periodic version cleaning started, cleaning deleted versions older than : {}", (Object)retentionPeriod);
        this.entityVersioningManager.cleanAllDeletedEntityVersionsOlderThan(retentionPeriod);
        log.info("[VERSIONING] Periodic version cleaning job finished successfully.");
        return JobRunnerResponse.success();
    }

    public Duration getRetentionPeriod() {
        String propertyValue = this.applicationProperties.getDefaultBackedString(RETENTION_DAYS_PROPERTY_KEY);
        try {
            return Duration.ofDays(Long.parseLong(propertyValue));
        }
        catch (NumberFormatException e) {
            log.error("[VERSIONING] NumberFormatException during parsing entity version retention days, falling back to the default value. Property key: {}, property value: {}, default value: {}", new Object[]{RETENTION_DAYS_PROPERTY_KEY, propertyValue, this.defaultRetentionPeriod});
            return this.defaultRetentionPeriod;
        }
    }

    public void start() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        Date fiveMinutesFromNow = Date.from(Instant.now().plus(5L, ChronoUnit.MINUTES));
        long intervalInMillis = TimeUnit.DAYS.toMillis(1L);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)intervalInMillis, (Date)fiveMinutesFromNow));
        try {
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
            log.info("[VERSIONING] Version cleaning job registered with the interval of: {}", (Object)Duration.ofMillis(intervalInMillis));
        }
        catch (SchedulerServiceException e) {
            log.error("[VERSIONING] Exception during job registration", (Throwable)e);
        }
    }

    public void stop() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        log.info("[VERSIONING] Version cleaning job unregistered");
    }
}

