/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.web.TempFileRemovingMultipartRequest;
import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import webwork.multipart.MultiPartRequest;

public class TempFileRemovingMultipartRequestWrapper
extends MultiPartRequest {
    private final Map<String, List<String>> parameterValueCache = new HashMap<String, List<String>>();
    private final TempFileRemovingMultipartRequest multi;

    public TempFileRemovingMultipartRequestWrapper(HttpServletRequest servletRequest, String saveDir, int maxSize) {
        this.multi = new TempFileRemovingMultipartRequest(servletRequest, saveDir, maxSize);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.multi.getParameterNames());
    }

    public String getParameter(String name) {
        return this.parseParameterValue(this.multi.getParameter(name));
    }

    public String[] getParameterValues(String name) {
        return this.retrieveParameterValues(name).isEmpty() ? null : this.retrieveParameterValues(name).toArray(new String[0]);
    }

    public Enumeration<String> getFileNames() {
        return Collections.enumeration(this.multi.getFileParameterNames());
    }

    public String getFilesystemName(String name) {
        return this.multi.getFilesystemName(name);
    }

    public String getContentType(String name) {
        return this.multi.getContentType(name);
    }

    public File getFile(String name) {
        return this.multi.getFile(name);
    }

    public void cleanup() {
        this.multi.cleanUp();
    }

    private String parseParameterValue(String value) {
        List<String> retVal = this.retrieveParameterValues(value);
        return retVal.isEmpty() ? null : retVal.get(0);
    }

    private List<String> retrieveParameterValues(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        return this.parameterValueCache.computeIfAbsent(string, key -> this.multi.getParameterValues((String)key).stream().map(value -> StringUtils.escapeCP1252((String)value, (String)this.getJiraEncoding())).collect(Collectors.toList()));
    }

    private String getJiraEncoding() {
        return ComponentAccessor.getApplicationProperties().getEncoding();
    }
}

