/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.cluster.logging.LoggingManager;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.ViewLogging;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@WebSudoRequired
public class ConfigureLogging
extends ViewLogging {
    private String loggerName;
    private String levelName;
    private Logger logger;

    public ConfigureLogging(MailServerManager mailServerManager, MailLoggingManager mailLoggingManager, LoggingManager loggingManager) {
        super(mailServerManager, mailLoggingManager, loggingManager);
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST, RequestMethod.GET})
    protected String doExecute() throws Exception {
        Logger logger = this.getLogger();
        this.loggingManager.setLogLevel(logger.getName(), this.levelName);
        return this.returnComplete("ViewLogging.jspa");
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = "".equals(this.loggerName) ? this.getRootLogger() : LogManager.getLogger((String)this.loggerName);
        }
        return this.logger;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }
}

